#include "mbed.h"

struct Point{
    float x;
    float y;
};

class Sonar{
    public:
    Sonar(PinName trig, PinName echo, float angle_z = 0, float x = 0, float y = 0, float z = 0);
    float getDistance();
    float getLastDistance() {return _distance;}
    Point getCoordinate();
    void autoPulse(bool on_off, float frequency_ms = 1);
    void pulse();
    
    private:
    Ticker _ticker;
    Timer _timer;
    DigitalOut _trig;
    InterruptIn _echo;
    
    int _begin;
    int _end;
    float _distance;
    bool _pinged;
    
    float _ratio_x;
    float _ratio_y;
    float _x;
    float _y;
    float _z;
    
    void echoBegin();
    void echoEnd();
};