#include "Hardware.h"

 Hardware::Hardware()
{

}
  
InitResult Hardware::init()
{
    //this->led1 = new DigitalOut(LED1, 1);
    this->led = new PwmOut(LED1);
    this->led->period_ms(20);
    this->led->write(0.0f);    
    this->pc = new Serial(USBTX, USBRX);// tx, rx
    
    this->initCli();
    
    MbedJSONValue demo;
   std::string s;
 
   //fill the object
   demo["my_array"][0] = "demo_string";
   demo["my_array"][1] = 10;
   demo["my_boolean"] = false;
 
   //serialize it into a JSON string
   s = demo.serialize();
   this->pc->printf("json: %s\r\n", s.c_str());
    
    return InitResultOk;
}

InitResult Hardware::initCli(){
    //this->pc->printf("INIT CLI\n"); 
    this->myCli = new Cli(this->pc, "#~> ", 50, 10);
    this->myCli->setEcho(true);
    this->myCli->appendCmd("print", "prints hello world to stream", static_cast<void*> (this), Hardware::cb_print);
    this->myCli->welcome();
    this->myCli->prompt();
    
    BLE &ble = BLE::Instance();
    this->bleSerial = new BleSerial(ble);
    this->bleCli = new Cli(this->bleSerial, "#~> ", 50, 10);
    this->bleCli->appendCmd("print", "prints hello world to stream", static_cast<void*> (this), Hardware::cb_print);
    this->bleCli->setEcho(true);
    this->bleCli->welcome();
    this->bleCli->prompt();
    
    return InitResultOk;
}

CbResult Hardware::cb_print(void* pObject, va_list args)
{
    if (!pObject)
    {
        return CbResultError;
    }

    char* s = static_cast<char*>(va_arg(args, char*));
    Stream *io = static_cast<Stream*>(va_arg(args, Stream*));
    va_end(args);

    Hardware* mySelf = static_cast<Hardware*> (pObject);

    //mySelf->pc->printf("HALLO WELT %s\n", s);
    io->printf("HALLO WELT %s\n", s);

    return CbResultOk;
}