/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "BleSerial.h"
#include "platform/mbed_wait_api.h"

//#if DEVICE_SERIAL

namespace mbed {

BleSerial::BleSerial(BLE &_ble) : Stream() {
    this->bleUart = new UARTService(_ble);
}

    //bool BleSerial::readable() const{
    //    return (bool) numBytesReceived;
    //}

    ssize_t BleSerial::write(const void* buffer, size_t length){
        return this->bleUart->write(buffer, length);
    }
    
    int BleSerial::_putc(int c){
        return this->bleUart->_putc(c);
    }
    
    int BleSerial::_getc(){
        return this->bleUart->_getc();   
    }
    
        /**
     * Note: TX and RX characteristics are to be interpreted from the viewpoint of the GATT client using this service.
     */
    uint16_t BleSerial::getTXCHandle() {
        return this->bleUart->getTXCharacteristicHandle();
    }

    /**
     * Note: TX and RX characteristics are to be interpreted from the viewpoint of the GATT client using this service.
     */
    uint16_t BleSerial::getRXCHandle() {
        return this->bleUart->getRXCharacteristicHandle();
    }

} // namespace mbed

//#endif
