/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MBED_BLESERIAL_H
#define MBED_BLESERIAL_H

#include "platform/platform.h"

//#if defined (DEVICE_SERIAL) || defined(DOXYGEN_ONLY)

#include "Stream.h"
#include "UARTService.h"
#include "platform/NonCopyable.h"

namespace mbed {

class BleSerial : public Stream, private NonCopyable<BleSerial> {

public:
    //using UARTService::write;
    //using Stream::read override;
    virtual ssize_t write(const void* buffer, size_t length);

    BleSerial(BLE &_ble);
    
    uint16_t getTXCHandle();
    uint16_t getRXCHandle();

    //bool readable();
    //writeable: return (bool) BLE_UART_SERVICE_MAX_DATA_LEN - sendBufferIndex;

protected:
    //using UARTService::_getc;
    //using UARTService::_putc;
    virtual int _putc(int c);
    virtual int _getc();
private:
    UARTService *bleUart;
};

} // namespace mbed

#endif

//#endif