
#include "TextLCD.h"
#include "mbed.h"
#include "adc.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

#define SAMPLE_RATE     150000
#define NUM 3000
Ticker ticker;
EthernetNetIf ethif(IpAddr(192,168,11,26), IpAddr(255,255,255,0), IpAddr(192,168,11,1), IpAddr(192,168,11,1));
    HTTPServer server;
    LocalFileSystem local("local");
    FILE *fp; 
TextLCD lcd(p24, p26, p27, p28, p29, p30);
int x;
int volt_max;
DigitalOut mled1(LED1);
DigitalOut mled2(LED2);
DigitalOut mled3(LED3);
DigitalOut mled4(LED4);
InterruptIn in_p6(p6);
DigitalIn di(p5); 
DigitalOut check(p8);

ADC adc(SAMPLE_RATE, 1); 

int main()
{
int volt[2000];
int a[5];
int n=0, m=0, p=0, v=0, q=0;
int v1, v2, v3;
int min;
    check = 0;
    
    adc.setup(p19,1);
            volt_max=0;
            mled1 = 1;
    Base::add_rpc_class<DigitalOut>();

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Program init..  ");

    if (ethif.setup()) {
        error("Ethernet setup failed.");
        return 1;
    }
    
    wait(1);
    server.addHandler<SimpleHandler>("/hello");
    server.addHandler<RPCHandler>("/rpc");
    FSHandler::mount("/local", "/");
    server.addHandler<FSHandler>("/");
    server.bind(80);
    
while(1){
    n=0; q=0; p=0; m=0; v=0;
if(di){ 
            mled2= 1;
            for(n=1;n<2000;n++){
                adc.select(p19);         // Measure pin 19
                adc.start();             // Start ADC conversion
                while(!adc.done(p19));   // Wait for it to complete
                volt[n]=adc.read(p19);
                mled3 = 1;
                        }
         mled4=1;
         mled1=mled3=0;                                        //while loop end
         
         volt_max=1;
            for( n = 100; n < 1800; n++ ){
                    if(volt_max<volt[n]*3300/4096){
                    volt_max=volt[n]*3300/4096;
                    m=n;
                    }  
        if(v==0){
            if(volt_max > 570){
                    p=m;
                    v=1;
                    x=p*100/610;
                                }
                }    
                    }      
    v1=3720.9*exp(-0.009*x);
    v2=2589.6*exp(-0.035*x);
    v3=828.39*exp(-0.041*x); 
    
    a[0]=abs(volt_max-v1);
    a[1]=abs(volt_max-v2);
    a[2]=abs(volt_max-v3);
    
    if(x > 29 && x < 151){    
    min=a[0];
    for(n = 1 ; n < 3 ; n++ ){
        if(min > a[n]){
            min=a[n];
            q=n;
            }
        }
    lcd.cls();        
/*    if(q==0){
                lcd.locate(0,0);
                lcd.printf("acrylic plate");
            }
        else if(q==1){
                lcd.locate(0,0);
                lcd.printf("towel");
                      }
        else if(q==2){
                lcd.locate(0,0);
                lcd.printf("sponge");
                      } 
            }
    else { 
          lcd.locate(0,0);
          lcd.printf("Undeterminable");
          }                    */
        lcd.locate(0,1);
        lcd.printf("%d[mV]  %d[cm]",volt_max,x);
        if (x>50 && x<120) check = 1;
        else check = 0;
        }
        }
    }}      