
#ifndef ENCODER_H
#define ENCODER_H

#include "QEI.h"
#include "mbed.h"
#include "globals.h"

class Encoder{
private:
    DigitalIn green, yellow;
    QEI wheel;
    
public:
    Encoder(PinName pGreen, PinName pYellow)
        : green(pGreen)
        , yellow(pYellow)
        , wheel(pGreen,pYellow, NC, 0, QEI::X4_ENCODING)
        {
    green.mode(PullUp);
    yellow.mode(PullUp);
    }
    
    int getTicks(void){
        return wheel.getPulses();
    }
    
    void reset (void){
        return wheel.reset();
    }
};

#ifdef ENABLE_GLOBAL_ENCODERS
    extern Encoder right_encoder;
    extern Encoder left_encoder;
#endif

#endif //ENCODER_H
