
// Eurobot13 Colour.h

//red led use 45ohm
//blue led use 10ohm

#include "mbed.h"

enum ColourEnum {BLUE, RED, WHITE, INCONCLUSIVE, BUG};

class Colour{
private:
    DigitalOut blue;   float bavg, bstdev;
    DigitalOut red;    float ravg, rstdev; 
    AnalogIn pt;
    
public:
    Colour(PinName bluePin, PinName redPin, PinName phototransistorPin)
        : blue(bluePin)
        , red (redPin)
        , pt (phototransistorPin)
        {
        LedsOff();
    }

    void Calibrate(){
        ReadLed(blue, bavg, bstdev);
        ReadLed( red, ravg, rstdev);
    }
        
    ColourEnum getColour(){
        bool blueb = isColour(blue, bavg, bstdev)
            , redb = isColour( red, ravg, rstdev);
                  
        if      ( blueb &&  redb)
                    {return WHITE;}
        else if ( blueb && !redb)
                    {return BLUE;}
        else if (!blueb &&  redb)
                    {return RED;}
        else if (!blueb && !redb)
                    {return INCONCLUSIVE;} 
        return BUG;            
    }

private:
    void LedsOff(){blue = 0; red = 0;}
    void ReadLed (DigitalOut &led, float &avg, float &stdev, const int measureNum = 25); // Colour.cpp
    bool isColour(DigitalOut &led, const float &avg, const float &stdev, const float numstddev = 2); // Colour.cpp
    
};