#include "Printing.h"
#ifdef PRINTINGOFF
void printingThread(void const*){Thread::wait(osWaitForever);}
bool registerID(char, size_t){return true;}
bool unregisterID(char) {return true;}
bool updateval(char, float*, size_t){return true;}
bool updateval(char id, float value){return true;}
#else
#include <iostream>
using namespace std;

size_t idlist[NUMIDS]; // Stores length of buffer 0 => unassigned
float* buffarr[NUMIDS];
volatile unsigned int newdataflags;

bool registerID(char id, size_t length) {   
    if (id < NUMIDS && !idlist[id]) {//check if the id is already taken
        idlist[id] = length;
        buffarr[id] = new float[length];
        return true;
    } else
        return false;
}
bool unregisterID(char id) {
    if (id < NUMIDS) {
        idlist[id] = 0;
        if (buffarr[id])
            delete buffarr[id];
        return true;
    } else
        return false;
}

bool updateval(char id, float* buffer, size_t length) {
    //check if the id is registered, and has buffer of correct length
    if (id < NUMIDS && idlist[id] == length && buffarr[id] && !(newdataflags & (1<<id))) {
        for (size_t i = 0; i < length; i++)
            buffarr[id][i] = buffer[i];
        newdataflags |= (1<<id);
        return true;
    } else
        return false;
}

bool updateval(char id, float value){
    //check if the id is registered, and the old value has been written
    if (id < NUMIDS && idlist[id] == 1 && buffarr[id] && !(newdataflags & (1<<id))) {
        buffarr[id][0] = value;
        newdataflags |= (1<<id);
        return true;
    } else
        return false;
}

void printingThread(void const*){
    newdataflags = 0;
    for (int i = 0; i < NUMIDS; i++) {
        idlist[i] = 0;
        buffarr[i] = 0;
    }


    Thread::wait(3500);
    while(true){   
        // Send number of packets
        char numtosend = 0;
        for (unsigned int v = newdataflags; v; numtosend++){v &= v - 1;}        
        cout.put(numtosend);

        // Send packets
        for (char id = 0; id < NUMIDS; id++) {
            if (newdataflags & (1<<id)) {
                cout.put(id);
                cout.write((char*)buffarr[id], idlist[id] * sizeof(float));
                newdataflags &= ~(1<<id);
            }
        }
        cout << endl;
        Thread::wait(200);
    }
}
#endif


 
