#include "globals.h"
#include "Kalman.h"
#include "mbed.h"
#include "rtos.h"
#include "Actuators/Arms/Arm.h"
#include "Actuators/MainMotors/MainMotor.h"
#include "Sensors/Encoders/Encoder.h"
#include "Sensors/Colour/Colour.h"
#include "Sensors/CakeSensor/CakeSensor.h"
#include "Processes/Printing/Printing.h"
#include "coprocserial.h"
#include <algorithm>

pos beaconpos[] = {{0,1}, {3,0}, {3,2}};

void motortest();
void encodertest();
void motorencodetest();
void motorencodetestline();
void motorsandservostest();
void armtest();
void motortestline();
void ledtest();
void phototransistortest();
void ledphototransistortest();
void colourtest();
void cakesensortest();
void printingtestthread(void const*);
void printingtestthread2(void const*);
void feedbacktest();

int main() {
    
/*****************
 *   Test Code   *
 *****************/
    //motortest();
    //encodertest();
    //motorencodetest();
    //motorencodetestline();
    //motorsandservostest();
    //armtest();
    //motortestline();
    //ledtest();
    //phototransistortest();
    //ledphototransistortest();
    //colourtest(); // Red SnR too low
    //cakesensortest();
    //feedbacktest();
    
     /*
    DigitalOut l1(LED1);
    Thread p(printingThread,        NULL,   osPriorityNormal,   2048);
    l1=1;
    Thread a(printingtestthread,    NULL,   osPriorityNormal,   1024);
    Thread b(printingtestthread2,   NULL,   osPriorityNormal,   1024);
    Thread::wait(osWaitForever);
    */
    
    
    InitSerial();
    //while(1)
    //    printbuff();
    wait(1);
    Kalman::KalmanInit();
    
    Thread predictthread(Kalman::predictloop, NULL, osPriorityNormal, 2084);//512); //temp 2k
    
    Kalman::start_predict_ticker(&predictthread);
    //Thread::wait(osWaitForever);
    feedbacktest();
    
}

#include <cstdlib>
using namespace std;

void printingtestthread(void const*){
    const char ID = 1;
    float buffer[3] = {ID};
    registerID(ID,sizeof(buffer)/sizeof(buffer[0]));
    while (true){
        for(size_t i = 1; i != sizeof(buffer)/sizeof(buffer[0]); ++i){
            buffer[i] = ID ;
        }
        updateval(ID, buffer, sizeof(buffer)/sizeof(buffer[0]));
        Thread::wait(200);
    }
}

void printingtestthread2(void const*){
    const char ID = 2;
    float buffer[5] = {ID};
    registerID(ID,sizeof(buffer)/sizeof(buffer[0]));
    while (true){
        for(size_t i = 1; i != sizeof(buffer)/sizeof(buffer[0]); ++i){
            buffer[i] = ID;
        }
        updateval(ID, buffer, sizeof(buffer)/sizeof(buffer[0]));
        Thread::wait(500);
    }
}


void feedbacktest(){
    //Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);
    
    Kalman::State state;
    
    float Pgain = -0.01;
    float fwdspeed = -400/3.0f;
    Timer timer;
    timer.start();
    
    while(true){
        float expecdist = fwdspeed * timer.read();
        state = Kalman::getState();
        float errleft = left_encoder.getTicks() - (expecdist);
        float errright = right_encoder.getTicks() - expecdist;
        
        mleft(max(min(errleft*Pgain, 0.4f), -0.4f));
        mright(max(min(errright*Pgain, 0.4f), -0.4f));
    }
}

void cakesensortest(){
    wait(1);
    printf("cakesensortest");
    
    CakeSensor cs(P_COLOR_SENSOR_IN);
    while(true){
        wait(0.1);
        printf("distance: %f\t %f\r\n", cs.Distance(),cs.Distanceincm());
        }
}

void colourtest(){
    Colour c(P_COLOR_SENSOR_BLUE, P_COLOR_SENSOR_RED, P_COLOR_SENSOR_IN);
    c.Calibrate();
    while(true){
        wait(0.1);
        ColourEnum ce = c.getColour();
        switch(ce){
            case BLUE :
                printf("BLUE\n\r");
                break;
            case RED:
                printf("RED\n\r");
                break;
            case WHITE:
                printf("WHITE\n\r");
                break;
            case INCONCLUSIVE:
                printf("INCONCLUSIVE\n\r");
                break;
            default:
                printf("BUG\n\r");
        }
    }

}


void ledphototransistortest(){
    DigitalOut blue(P_COLOR_SENSOR_BLUE), red(P_COLOR_SENSOR_RED);
    AnalogIn pt(P_COLOR_SENSOR_IN); 
    Serial pc(USBTX, USBRX);

    while(true){
        blue = 0; red = 0;
        for(int i = 0; i != 5; i++){
            wait(0.1);
            printf("Phototransistor Analog is (none): %f \n\r", pt.read());
        }
    
        blue = 1; red = 0;
        for(int i = 0; i != 5; i++){
            wait(0.1);
            printf("Phototransistor Analog is (blue): %f \n\r", pt.read());
        }
        blue = 0; red = 1;
        for(int i = 0; i != 5; i++){
            wait(0.1);
            printf("Phototransistor Analog is (red ): %f \n\r", pt.read());
        }
        blue = 1; red = 1;
        for(int i = 0; i != 5; i++){
            wait(0.1);
            printf("Phototransistor Analog is (both): %f \n\r", pt.read());
        }
    } 
}

void phototransistortest(){
    AnalogIn pt(P_COLOR_SENSOR_IN); 
    while(true){
        wait(0.1);
        printf("Phototransistor Analog is: %f \n\r", pt.read());
    }

}

void ledtest(){
    DigitalOut blue(P_COLOR_SENSOR_BLUE), red(P_COLOR_SENSOR_RED);
    while(true){
        blue = 1; red = 0;
        wait(0.2);
        blue = 0; red = 1;
        wait(0.2);
    
    }
}

void armtest(){
    Arm white(p26), black(p25, false, 0.0005, 180);
    while(true){
        white(0);
        black(0);
        wait(1);
        white(1);
        black(1);
        wait(1);
    }
}


void motorsandservostest(){
    Encoder Eleft(p27, p28), Eright(p30, p29);
    MainMotor mleft(p24,p23), mright(p21,p22);
    Arm sTop(p25), sBottom(p26);
    //Serial pc(USBTX, USBRX);
    const float speed = 0.0;
    const float dspeed = 0.0;
    
    Timer servoTimer;
    mleft(speed); mright(speed);
    servoTimer.start();
    while (true){
        printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        if (Eleft.getTicks() < Eright.getTicks()){
            mleft(speed);
            mright(speed - dspeed);
        } else {
            mright(speed);
            mleft(speed - dspeed);
        }
        if (servoTimer.read() < 1){
            sTop.clockwise();
        } else if (servoTimer.read() < 4) {
            sTop.halt();
        } else if (servoTimer.read() < 5) {
            sBottom.anticlockwise();
            //Led=1;
        } else if (servoTimer.read() < 6) {
            sBottom.clockwise();
            //Led=0;
        } else if (servoTimer.read() < 7) {
            sBottom.halt();
        }else {
            sTop.anticlockwise();
        }
        if (servoTimer.read() >= 9) servoTimer.reset();
    }
}

void motortestline(){
    MainMotor mleft(p24,p23), mright(p21,p22);
    const float speed = 0.2;
    mleft(speed); mright(speed);
    while(true) wait(1);
}

void motorencodetestline(){
    Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);
    //Serial pc(USBTX, USBRX);
    const float speed = 0.2;
    const float dspeed = 0.1;

    mleft(speed); mright(speed);
    while (true){
    //left 27 cm = 113 -> 0.239 cm/pulse
    //right 27 cm = 72 -> 0.375 cm/pulse
        printf("Position is: %i \t %i \n\r", (int)(Eleft.getTicks()*0.239), (int)(Eright.getTicks()*0.375));
        if (Eleft.getTicks()*0.239 < Eright.getTicks()*0.375){
            mright(speed - dspeed);
        } else {
            mright(speed + dspeed);
        }
    }

}

void motorencodetest(){
    Encoder Eright(P_ENC_RIGHT_A, P_ENC_RIGHT_B), Eleft(P_ENC_LEFT_A, P_ENC_LEFT_B);
    MainMotor mright(P_MOT_RIGHT_A, P_MOT_RIGHT_B), mleft(P_MOT_LEFT_A, P_MOT_LEFT_B);
    Serial pc(USBTX, USBRX);
    
    const float speed = -0.3;
    const int enc = -38;
    while(true){
        mleft(speed); mright(0);
        while(Eleft.getTicks()>enc){
            printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        }
        Eleft.reset(); Eright.reset();
        mleft(0); mright(speed);
        while(Eright.getTicks()>enc){
            printf("Position is: %i \t %i \n\r", Eleft.getTicks(), Eright.getTicks());
        }
        Eleft.reset(); Eright.reset();
    }
}

void encodertest(){
    Encoder E1(P_ENC_LEFT_A, P_ENC_LEFT_B);
    //Encoder E2(P_ENC_RIGHT_A, P_ENC_RIGHT_B);
    Serial pc(USBTX, USBRX);
    while(true){
        wait(0.1);
        printf("Position is: %i \t %i \n\r", E1.getTicks(), 0);//E2.getTicks());
    }

}
void motortest(){
    MainMotor mright(p22,p21), mleft(p23,p24);
    while(true) {
        wait(1);
        mleft(0.8); mright(0.8);
        wait(1);
        mleft(-0.2); mright(0.2);
        wait(1);
        mleft(0); mright(0);
    }
}