
// Eurobot13 Colour.cpp

#include "Colour.h"

void Colour::ReadLed (DigitalOut &led, float &avg, float &stdev, const int measureNum){
    LedsOff();
    led = 1;
    double x = 0, x2 = 0;
    for (int i = measureNum; i != 0; i--) {
        float v = pt.read();
        x += v;
        x2+= v*v;
    }
    avg = x / measureNum;
    stdev = sqrt(x2 / measureNum - avg*avg);
    LedsOff();
    //pc.printf("Phototransistor Analog is: %f\t%f\n\r", avg, stdev);
}

bool Colour::isColour(DigitalOut &led, const float &avg, const float &stdev, const float numstddev){
    float avg2, stdev2;
    ReadLed(led, avg2, stdev2);

    if (avg + numstddev*stdev < avg2 - numstddev*stdev2) {
        return true;
    } else {
        return false;
    }
}