
// Eurobot13 MainMotor.h

#include "mbed.h"

class MainMotor{
    private:
    PwmOut PWM1;
    PwmOut PWM2;
    
    public:
    MainMotor(PinName pin1, PinName pin2) : PWM1(pin1), PWM2(pin2){
    }
    
    void operator()(float in){
        power(in);
    }
    
    void power(float power){
        if( power > 0 ){
            PWM1 = power;
            PWM2 = 0;
        } else {
            PWM1 = 0;
            PWM2 = -power;    
        }
    }
    
    virtual void halt (void){
        //DigitalOut myled(LED2);
        //myled = 1;
        PWM1 = 0;
        PWM2 = 0;
    }

};