#ifndef STATEMACHINE_H
#define STATEMACHINE_H

#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"

enum State {INIT, CLIENT, SERVER, CERROR};

class StateMachine {
private:
    State currentState;
    void actionInit();
    void actionClient();
    void actionServer();
    PwmOut* r;
    PwmOut* g;
    PwmOut* b;
    AnalogIn* pot1;
    AnalogIn* pot2;
    DigitalIn* up;
    DigitalIn* down;
    DigitalIn* left;
    DigitalIn* right;

    C12832* lcd;
    
    LM75B* sensor;
    
    DigitalOut* led;
public:     
    StateMachine();
    ~StateMachine();
    
    void start();
};

#endif