#include "StateMachine.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"
    
    uint16_t temperature =(sensor.read());
    char upper = (temperature >> 8) & 0x00FF;
    char lower = temperature & 0x00FF;
    char pwm = (char)(pot1);
    char id = 0x14;

    char payload[4] = {upper, lower, pwm, id};
    
StateMachine::StateMachine(){
    r = new PwmOut(D5);
    g = new PwmOut(D9);
    b = new PwmOut(D8);
    
    pot1 = new AnalogIn (A0);
    pot2  = new AnalogIn(A1);
    up = new DigitalIn(A2);
    down = new DigitalIn(A3);
    left = new DigitalIn(A4);
    right = new DigitalIn(A5);

    lcd = new C12832(D11, D13, D12, D7, D10);
    
    sensor = new LM75B(D14,D15);
    
    led = new DigitalOut(LED1);
    
    
    currentState = INIT;
    }
    
StateMachine::~StateMachine(){
    delete r;
    delete g;
    delete b;
    delete pot1;
    delete pot2;
    delete up;
    delete down;
    delete left;
    delete right;

    delete lcd;
    
    delete sensor;
    
    delete led;
}

void StateMachine::start()
{
    while(true) 
    {
//            switch(currentState) {
//            case INIT:
//            actionInit();
//            currentstate =;
//            break;
//            case BLUE:
//            actionBlue();
//            currentState = INIT;
//            break;
//            case GREEN:
//            actionGreen();
//            currentState = INIT;
//            break;
//            default:
//            currentState = CERROR;
//            return;
        if(currentState == INIT){actionInit();}
        if(currentState == SERVER) {actionServer();}
        if(currentState == CLIENT) {actionClient();}    
    }
}

void StateMachine::actionInit(){
    printf("Select left for server, right for client.");
    if(left){currentState = SERVER;}
    if(right){currentState = CLIENT;}
    wait(1.0);
    }

void StateMachine::actionClient(){
    
    printf("Client example\n\r");
 
    EthernetInterface eth;
    eth.set_network("192.168.0.20","255.255.255.0","192.168.0.1");
    eth.connect();
 
    printf("The client IP address is '%s'\n\r", eth.get_ip_address());
 
    TCPSocket socket;
    socket.open(&eth);
    socket.connect("192.168.0.28",4000);
 

    
    payload[0] = upper;
    payload[1] = lower;
    payload[2] = pwm;
    payload[3] = id;
    
    printf("%d\n", upper);
    printf("%d\n", lower);

    // print hex value of temperature on lcd
    lcd.printf("Temp %.1x\n", sensor.read() );
    printf(payload);
    
    socket.send(payload, 4);
    socket.close();
    wait(1.0);
    }

void StateMachine::actionServer(){
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network("192.168.0.28","255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    srv.bind(4000);
    
    srv.listen();
    
    while(true){
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
                    
        client.send(buffer, 256);
        
        char rbuffer[4];
        client.recv(rbuffer, sizeof rbuffer);
        
        uint8_t upper = rbuffer[0];
        uint8_t lower = rbuffer[1];
        uint8_t PWM = rbuffer[2];
        uint8_t ID = rbuffer[3];        
        
        float temp = ((upper << 8) | lower) / 256.00;
        
        printf("Temperature is %f\n", temp);
        
        client.close();
        wait(1.0);
        }
}
