#include "refGen.h"
#include "mbed.h"

// Member function definitions
refGen::refGen(PinName a, float maxAngle):refPin(a), maxAngle(maxAngle), r_direction(false){

    }

double refGen :: getReference(){
    double r;
    if(r_direction == false){
        // Clockwise rotation yields positive reference
        r = maxAngle*refPin.read();
        }
    if(r_direction == true){
        // Counterclockwise rotation yields negative reference
        r = -1*maxAngle*refPin.read();
        }
    return r;
    }
    