#include "motorConfig.h"
#include "mbed.h"
#include "FastPWM.h"

// Constructor
motorConfig::motorConfig(PinName _directionPin, PinName _pwmPin):directionPin(_directionPin),pwmPin(_pwmPin){
    pwmPin.period(1.0/5000.0);
    directionPin = 0;
    }

// Other member function definitions
void motorConfig::setMotor(float motorValue){
    // Set motor direction
    if (motorValue >=0){
        // corresponds to CW rotation of motor axle
        directionPin.write(0);
        } else if(motorValue < 0){
        // corresponds to CCW rotation of motor axle
        directionPin.write(1);
        }
                        
    // Set motor speed
    if (fabs(motorValue)>1){ 
        pwmPin = 1.0;
        }
    else {
        pwmPin.write(fabs(motorValue) + 0.4);
        }
                          
    }
    
void motorConfig::kill(){
//    currentState = KILLED;
    pwmPin.write(0.0);
                
    }