#ifndef ERRORFETCH_H
#define ERRORFETCH_H

#include "mbed.h"
#include "QEI.h"

class errorFetch {
public:
    errorFetch(float, float); // Constructor sets up the pin to read the reference from
    volatile float e_pos;
    volatile float e_int;
    volatile float e_der;
    volatile float e_prev;
    
    double fetchMotorPosition(int counts);
    void fetchError(double motorPosition, double ref); // Gets reference position on specified pin
    
private:
    const float gearRatio;
    const float Ts;
    };
#endif