#include "biquadFilter.h"
#include "mbed.h"

// Member function definitions
biquadFilter::biquadFilter(double B0, double B1, double B2, double A0, double A1, double A2):b0(B0),b1(B1),b2(B2),a0(A0),a1(A1),a2(A2){
    // Initializing filter coefficients
    v = 0;
    y = 0;
    v1 = 0;
    v2 = 0;
    }

double biquadFilter :: filterInput(double u){
    v = u - a1*v1 - a2*v2;
    y = b0*v + b1*v1 + b2*v2;
    
    // Prepare for next sample
    v2 = v1;
    v1 = v;
    
    return y;
    }