/**
@file    sc_functions.h
@author  Tu Tri Huynh
@date    January 15, 2021
@brief   Functions used for Serial Communication during service.
*/

/**
This function will prompt the user for which sensor data to fetch and print to console.
1/15/2021
*/
void sc_read_input()
{
    char choice;
    printf("Your input: ");
    scanf("%1s", &choice);    
    if (choice == '1')
    {
        printf("Current light intensity: %1.2f\n", light_sensor.read());
    }
    else if (choice == '2')
    {
        printf("Current rotary position: %1.2f\n", rotary.read());
    }
    else if (choice == '3')
    {
        printf("Current celsius temperature: %2.2f\n", temp.getTemperature());
    }
    else if (choice == '4')
    {
        float fahrenheit = helper_convert_celsius_to_fahrenheit(temp.getTemperature());
        printf("Current fahrenheit temperature: %3.2f\n", fahrenheit);
    }
    else
    {
        printf("Invalid choice.\n");
    }
    /// This will empty the buffer and will avoid already inputted data to be used in scanf etc.
    int c;
    do 
    {
        c = getchar();
    } while (c != EOF && c != '\n');
}

/**
This function will show the menu for serial communication.
1/15/2021
*/
void sc_show_menu()
{
    printf("*********************************************************************\n");
    printf("To get data from the sensors, please enter a number and press return.\n");
    printf("Input 1 to get current light intensity.\n");
    printf("Input 2 to get the current position of rotary control button.\n");
    printf("Input 3 to get the current temperature in celcius.\n");
    printf("Input 4 to get the current temperature in fahrenheit.\n");
    sc_read_input();
}


/**
This function will run the serial communication service.
1/15/2021
*/
void sc_run_service()
{
    while(1)
    {
        sc_show_menu();
    }
}