/**
@file    time_functions.h
@author  Tu Tri Huynh
@date    January 20, 2021
@brief   Functions related to getting and displaying the time
*/

#include "Timezone.h"

/**
Connects to an NTP server and updates the time to display.
Currently only works with UTC time.
1/20/2021
*/
void time_update_current_time() 
{
    char current_time[32];
    /// Ethernet connection declared in main.cpp
    eth.connect();
 
    if (ntp.setTime("0.pool.ntp.org") == 0) 
    {
        printf("\nTime successfully retrieved\n");        
    } 
    else 
    {
        printf("\nFailed to retrieve time from NTP server.\n");
    }

    eth.disconnect();
    
    time_t dk_time;
    TimeChangeRule dk_standardtime = {"DNT", Last, Sat, Oct, 3, 60};
    //TimeChangeRule dk_daylight = {"DST", Last, Sun, Mar, 2, 120}; 
    Timezone danish_time(dk_standardtime);
    //Timezone danish_time(dk_daylight, dk_standardtime);
    
    //dk_tid = danish_timetoLocal(ctTime);
    
    while(1)
    {
        time_t seconds = time(NULL);
        dk_time = danish_time.toLocal(seconds);

        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&dk_time));
        //printf("Time as a custom formatted string = %s", buffer);
        sprintf(current_time, "%s", buffer);
        lcd_update_upper_left(current_time);

        ThisThread::sleep_for(20s);
    }
}