/**
@file    setup_functions.h
@author  Tu Tri Huynh
@date    January 13, 2021
@brief   Functions used for initial setup of the unit, specifically to set the building and room where unit installation is planned.
*/

/**
Declaration of the function (prototype) to allow other functions to call it
@date 1/13/2021
*/
void setup_set_room_and_building();

/**
Prompt user for confirmation if happy with inputted information
1/13/2021
*/
void setup_confirm()
{
    char answer;
    printf("Type y for Yes, n to redo: ");
    scanf("%1s",&answer);
    if (answer == 'y' || answer == 'Y')
    {
        printf("Setup successfully completed.\n");
    }
    else
    {
        /// This will empty the buffer and will avoid already inputted data to be used in scanf etc.
        int c;
        do {
            c = getchar();
        } while (c != EOF && c != '\n');
        
        setup_set_room_and_building();
    }
    /**
    printf("setup_confirm function end\n");
    */
}

/**
Show inputted information, and call setup_confirm to ask for confirmation.
1/13/2021
*/
void setup_show_settings()
{
    printf("Is this correct?\n");
    printf("----------------------------\n");
    printf("Building: %s\n", building);
    printf("Room: %s\n", room);
    printf("----------------------------\n");
    setup_confirm();  
}

/**
Function to set building and room. Will call setup_show_settings to show what has been inputted.
1/13/2021
*/
void setup_set_room_and_building()
{
    char temp;
    /** 1/14/2021 
       When using %s, string will be terminated when white space is found.
       Therefore, set it to read white spaces with %[^\n]
       Also, changed wording to reduce "please" sentences.*/
    /**
    printf("Please set the building (maximum 30 characters): ");
    scanf("%30s", building);
    printf("Please set the room (maximum 30 characters): ");
    scanf("%30s", room); */
    printf("Enter name of building (maximum 30 characters): ");
    scanf("%[^\n]", building);
    printf("Enter name of room (maximum 30 characters): ");
    /// temp statement to clear buffer
    scanf("%c", &temp);
    scanf("%[^\n]", room);
    
    setup_show_settings();
}

/**
Function to run the initial setup process.
1/13/2021
*/
void setup_run_setup()
{
    printf("\n*********************************************************\n");
    printf("Welcome to the Light Control System initial setup process\n");
    printf("Please set the units' location...\n\n");
    setup_set_room_and_building();
}