/**
@file    rotary_functions.h
@author  Tu Tri Huynh
@date    January 14, 2021
@brief   Functions related to the Grove Rotary Angle Sensor
*/

/** 
Check if rotary has been turned. Returns true if rotary has been turned to a certain point (margin set).
@param rot AnalogIn rotary angle sensor object.
1/14/2021
*/
bool rotary_is_on(AnalogIn rot)
{
    if (rot.read() >= 0.04f) {
        return true;
    }
    return false;
}

/**
Reverses the value of the analog rotary reading, which reads the resistance of the rotary so 0 becomes 1 and 1 becomes 0. 
The rotary increases in resistance as the rotary is turned, while the light sensor decreases its resistance as light intensity increases.
The led_set_blink_rate() function is fitted to the light sensor read values and set to decrease blinking speed the higher the value.
This function can be used to reverse the value of the registered rotary resistance value so it can be used with the LED blinking function.
@param rotary_value Rotary angle sensor read value.
1/14/2021
*/
float rotary_reverse_read(float rotary_value)
{
    return (1 - rotary_value);
}
