/**
@file    main_functions.h
@author  Tu Tri Huynh
@date    January 18, 2021
@brief   Functions to be envoked in main function. Uses global variables.
*/

/**
This function will update the sensor readings.
1/18/2021
*/
void main_update_readings()
{
    light_sensor_reading = light_sensor.read();    
    light_intensity = helper_get_sensor_read_in_percent(light_sensor_reading);
    rotary_reading = rotary.read();
    rotary_setting = helper_get_sensor_read_in_percent(rotary_reading);
}

/**
This function will check which sensor controls the light, allowing the rotary or the light sensor to determine blink rate, 
and updates the lcd display accordingly
1/19/2021
*/
void main_check_light_control()
{
    if (rotary_is_on(rotary))
    {
        led_set_blink_rate(rotary_reverse_read(rotary_reading));
    }
    else
    {
        led_set_blink_rate(light_sensor_reading);
    }
    
    lcd_update_upper_right(light_intensity, rotary_setting);
}

/**
Reads the temperature and updates the display if temperature has changed.
1/19/2021
*/
void main_update_temperature(bool switch_temp)
{
    int new_temp = (int)temp.getTemperature();
    /// Update if change in temperature
    if (current_temp != new_temp) 
    {
        current_temp = new_temp;
        lcd_update_lower_right(temp.getTemperature(), is_fahrenheit);
    }
    /// Check if change temperature unit wanted
    else if (switch_temp == true)
    {
        lcd_update_lower_right(temp.getTemperature(), is_fahrenheit);
    }
}

/**
Runs a while loop that checks for button presses
1/19/2021
*/
void main_run_button_check()
{
    while(1)
    {
        switch_temp = button_switch_temp_unit(button, is_fahrenheit);
        main_update_temperature(switch_temp);
        switch_temp = false;
        wait_us(250000);
    }
}

/**
Runs the setup menu
1/19/2021
*/
void main_run_setup()
{
    lcd_initialize();
    lcd_show_setup_screen();
    setup_run_setup();
}

/**
Starts the main screen on LCD display
1/19/2021
*/
void main_run_main_screen()
{
    lcd_show_main_screen();
    lcd_update_lower_left(building, room);
}

