/**
******************************************************************************
@file    main.cpp
@author  Tu Tri Huynh
@date    January 13, 2021
@brief   Light Control System to automatically dimmer or increase light levels
@section Libraries used
mbed-os version 6.6.0
BSP_DISCO_F746NG, revision 13:85dbcff by Team ST
Grove_temperature, v1.0.0 by Toyomasa Watarai
NTPClient, revision 0:9282d46 by Zoltan Hudak
Timezone, revision 0:38a95c8, originally by Jack Christensen and ported by Zoltan Hudak
 
@section Recommended hardware to run the program
STM32F746G-DISCOVERY
Grove Base Shield v2.1
Grove Light Sensor  v1.2    
Grove Rotary Angle Sensor v1.2
Grove LED Socket Kit v1.5
Grove LED diode
Grove Button v1.2
Grove Temperature Sensor v1.2
******************************************************************************
*/

#include "mbed.h"
#include "Grove_temperature.h"
#include "stm32746g_discovery_lcd.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

AnalogIn light_sensor(A0);
AnalogIn rotary(A1);
DigitalIn button(D5);
PwmOut led(D3);
Grove_temperature temp(A2);
EthernetInterface eth;
NTPClient ntp(eth);
/// Name of building to install the unit
char building[31];
/// Name of room to install the unit
char room[31];

float light_sensor_reading;
float rotary_reading;
/// The percentage of light registered 
int light_intensity;
/// The percentage of rotary turned
int rotary_setting;

/// Used to determine if change in temperature has occured when new readings are performed
int current_temp;
/// Used to check if temperature unit should be switched or not
bool switch_temp;
bool is_fahrenheit = false;


/*DigitalOut myled(LED1);*/

#include "helper_functions.h"
#include "setup_functions.h"
#include "lcd_functions.h"
#include "led_functions.h"
#include "rotary_functions.h"
#include "sc_functions.h"
#include "button_functions.h"
#include "main_functions.h"
#include "time_functions.h"


int main()
{        
    main_run_setup();
    main_run_main_screen();
        
    Thread serial_communication;
    serial_communication.start(&sc_run_service);
    
    Thread clock;
    clock.start(&time_update_current_time);
    
    Thread button_check;
    button_check.start(&main_run_button_check);
    
    while(1)
    {
        main_update_readings();
        main_check_light_control();
        
        wait_us(1000000);
        
        /** Code for testing temperature sensor
            1/18/2021 - Working
        */
        /**
        printf("Current temperatur is: %2.2f\n", temp.getTemperature());
        wait_us(1000000);
        */

        /** Code for testing that the rotary can control the LED light blinking
            1/14/2021 Working
        */
        /**
        rotary_reading = rotary_reverse_read(rotary);
        printf("%1.2f\n",rotary_reading);
        led_set_blink_rate(rotary_reading);
        wait_us(2000000);
        */

        /** Code for testing if rotary has been turned or not
            1/14/2021 Working
        */
        /**
        if (rotary_is_on(rotary))
        {
            printf("Rotary is on\n");
        }
        else
        {
            printf("Rotary is off\n");
        }
        wait_us(1000000);
        */

        /** Code for testing sensor readings
            1/14/2021 Working
        */
        /**
        light_sensor_reading = light_sensor.read();
        rotary_reading = rotary.read();
        printf("Light intensity: %i%%\n", helper_get_sensor_read_in_percent(light_sensor_reading));
        printf("Rotary turned: %i%%\n", helper_get_sensor_read_in_percent(rotary_reading));
        led_set_blink_rate(light_sensor_reading);
        wait_us(1000000);
        */

        /** 1/13/2021 Used to test the controller and make sure that it functions.*/
        /**
        printf("This is a test.\n");
        myled = 1;
        wait_us(1000000);
        myled = 0;
        wait_us(1000000);
        */

        /**
        printf("Mbed OS version: %d,%d,%d\n\n",MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
        */
    }    
}