/**
@file    led_functions.h
@author  Tu Tri Huynh
@date    January 14, 2021
@brief   Functions to control Grove LED.
*/

/**
This function will use the sensor_value and determine LED blinking rate.
The closer the value is to 0.00f the more frequent it will blink or even completely light up.
@value Float value from the read() function in analog units. Must be between 0 and 1.
1/14/2021
*/
void led_set_blink_rate(float value)
{
    /// Turn on LED completely (no blinking)
    if (value < 0.10f) {
        led.period(1.00f);
        led.write(1.00f);
    }
    /// Blink very fast
    else if (value >= 0.10f && value < 0.30f) {
        led.period(0.13f);
        led.write(0.25f);
    }
    /// Blink fast
    else if (value >= 0.30f && value < 0.50f) {
        led.period(0.25f);
        led.write(0.50f);
    }
    /// Blink
    else if (value >= 0.50f && value < 0.70f) {
        led.period(0.50f);
        led.write(0.50f);
    }
    /// Blink slow
    else if (value >= 0.70f && value < 0.90f) {
        led.period(1.00f);
        led.write(0.50f);
    }
    /// If value is 1.00 turn off LED
    else {
        led.period(1.00f);
        led.write(0.00f);
    }
    //printf("Blink rate on this value: %0.2f\n", value);
}