/**
@file    helper_functions.h
@author  Tu Tri Huynh
@date    January 14, 2021
@brief   Functions to help with general tasks.
*/

/**
This function returns the percentage of AnalogIn sensor read values that by default are floating point numbers between 0.00 to 1.00.
@param read_value Float value from the read() function in analog units
@return whole number that represents percentage.
1/14/2021
*/
int helper_get_sensor_read_in_percent(float read_value)
{
    return (int)(read_value*100);
}

/**
This function returns a rounded float value, used for temperature readings.
@param temp Temperature value to be rounded
*/
float helper_round_temperature(float temp)
{
    return floorf(temp * 100)/100;
}

/**
This function converts Celsius temperature to Fahrenheit.
@param temp Celsius value
*/
float helper_convert_celsius_to_fahrenheit(float temp)
{
    float fahrenheit = ((temp * 9)/5)+32;
    return fahrenheit;
}

/**
This function reverses the bool value.
@@param value Bool value to reverse.
1/18/2021
*/ 
bool helper_reverse_bool(bool value)
{
    return !value;
}