/*
Made by Tu Tri Huynh. 
January 7, 2021 - Rotary and light sensor functionality created
January 8, 2021 - Basic LCD output functionality created. Small fixes made.

Description:
Light sensor that will turn on a LED light depending on how light/dark it is
Also with a rotary angle sensor to fine tune the LED light,
effectively deactivating the light sensor control while the rotary is not in zero position.

LED light will blink slow or fast to imitate dampening of light.
*/

#include "mbed.h"
#include "sensor_light_control.h"
#include "lcd_functions.h"

int main()
{   
    char light_to_lcd[30]; // char array for light sensor LCD text output
    char rotary_to_lcd[30]; // char array for rotary sensor LCD text output
    float light_level = 0.00f; // how much light is registered
    float rotary_turnlevel = 0.00f; // how many percent the rotary has been turned
    
    lcd_initialize();
    lcd_show_startup_screen();
    lcd_show_main_screen();
    // Run program
    while (true) {
        // Check sensors for changes
        run_sensors();
        
        // Only if there's a change in registered levels of light, update LCD
        // This will avoid continuously updating LCD
        if (light_level != get_light_level())
        { 
            // Update the saved value
            light_level = get_light_level();
            // Convert to text
            sprintf(light_to_lcd, "Light: %3.0f%%", light_level);
            BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
            // Output to LCD
            BSP_LCD_DisplayStringAt(0, 6, (uint8_t *)light_to_lcd, RIGHT_MODE);
        }
        
        // Only if there's a change in registered levels of rotary, update LCD
        // This will avoid continuously updating LCD
        if (rotary_turnlevel != get_rotary_turnlevel())
        { 
            // Update the saved value
            rotary_turnlevel = get_rotary_turnlevel();
            // Convert to text
            sprintf(rotary_to_lcd, "Rotary: %3.0f%%", rotary_turnlevel);
            BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
            // Output to LCD
            BSP_LCD_DisplayStringAt(0, 30, (uint8_t *)rotary_to_lcd, RIGHT_MODE);
        }
        
        /***** Retrieve LCD size *****/
        //printf("LCD X size : %zu\n\r",BSP_LCD_GetXSize()); //result: 480
        //printf("LCD Y size : %zu\n\r",BSP_LCD_GetYSize()); //result: 272
                
        wait_us(500000);        
    }
}