/**
lcd_functions.h

This file contains code for outputting to the LCD screen.
LCD size is (480, 272)
*/
#include "stm32746g_discovery_lcd.h"

// Initializes the LCD for use
void lcd_initialize()
{
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS); // Initialize LCD layers
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER); // Select the LCD Layer
}

// Runs the startup screen with name and project name
void lcd_show_startup_screen()
{    
    // Startup screen
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
    BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)"Light Control System", CENTER_MODE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0, 200, (uint8_t *)"by Tu Tri Huynh", CENTER_MODE);
    HAL_Delay(3000);
}

/*
Screen is divided into four parts equal in size
*/

// Sets up the upper left part of screen
void lcd_upper_left()
{
    
}

// Sets up the upper right part of screen
void lcd_upper_right()
{
    BSP_LCD_SetBackColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_FillRect(240, 0, 240, 136);
}

// Sets up the lower left part of screen
void lcd_lower_left()
{
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_FillRect(0, 136, 240, 136);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    // Set font to be smaller for this part
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_DisplayStringAt(5, 160, (uint8_t *)"Tu Tri Huynh", LEFT_MODE);
    BSP_LCD_DisplayStringAt(5, 180, (uint8_t *)"Embedded Programming", LEFT_MODE);
    BSP_LCD_DisplayStringAt(5, 200, (uint8_t *)"Light Control System", LEFT_MODE);
    // Reset fontsize
    BSP_LCD_SetFont(&Font16);
}

// Sets up the upper right part of screen
void lcd_lower_right()
{
    BSP_LCD_SetTextColor(LCD_COLOR_CYAN);
    BSP_LCD_FillRect(240, 136, 240, 136);
}

// Shows the main screen
void lcd_show_main_screen()
{
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE); // Clear with color
    
    lcd_lower_left();
    lcd_lower_right();
    lcd_upper_right();
    
    /******** DEMO CODE EXAMPLE *****/
    /*
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE); // Clear and set color
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_DrawRect(10, 20, 50, 50);
    BSP_LCD_SetTextColor(LCD_COLOR_BROWN);
    BSP_LCD_FillCircle(80, 80, 50);
    BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
    BSP_LCD_DrawEllipse(150, 150, 50, 100);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);
    BSP_LCD_FillCircle(200, 200, 40);
    HAL_Delay(2000);
    
    
    BSP_LCD_SetBackColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_ORANGE);
    //BSP_LCD_DisplayStringAt(0, 6, (uint8_t *)output, RIGHT_MODE);
    //HAL_Delay(2000);
    */
}