/*___________________________________________________________*/
/*      A simple LCD program for ARM mbed IoT Starter Kit    */
/*      LCD name    :   C12832A1Z LCD   : 128X32             */
/*              nCS     :   D10     :   PTD0                 */   
/*              A0      :   D7      :   PTC3                 */
/*              SCK     :   D13     :   PTD1                 */
/*              RESET   :   D12     :   PTD3                 */
/*              MOSI    :   D11     :   PTD2                 */
/*___________________________________________________________*/
/*                  AUTHOR  :   mudz                         */
/*___________________________________________________________*/

#include "mbed.h"
#include "C12832.h"
#include "Arial12x12.h"
#include "Small_7.h"


DigitalOut gpo(D0);
DigitalOut led(LED_GREEN);
DigitalOut ledR(LED_RED);
DigitalOut ledB(LED_BLUE);
C12832 lcd(D11, D13, D12, D7, D10);

/**
 * Display a message on the LCD screen
 */
void displayMessage(char* message)
{
    lcd.cls();
    lcd.printf(message);
}

int main()
{
    int i=4;
    while (true) 
    {
        lcd.set_contrast(i);                            // Use i to control Contrast value
        
        if(i%2==0)
        {
            lcd.set_font((unsigned char*) Arial12x12);  // Set Arial font for the LCD screen
            lcd.locate(8,8);                            // Location of the Text on Screen
            ledR = !ledR; // toggle led
        }
       
        if(i%2==1)
        {
            lcd.set_font((unsigned char*) Small_7);     // Set Small_7 font for the LCD screen
            lcd.locate(16,12);
            ledB = !ledB; // toggle led
        }
        
        displayMessage("Hello Sir, I'm Online");        // Message
        gpo = !gpo;                                     // toggle pin
        led = !led;                                     // toggle led
      
        wait(0.8f);
        i++;
        if(i==35)                                       // Contrast value after this text will not be visible
        {
            i=4;                                        // Contrast value 
        }
        
       }
}