#include "mbed.h"
#include "DebounceIn.h"

#define MAX_SPEED 12800 //16oborotov na 800 shagov/sek
#define MIN_SPEED 250 //

#define SPD_INCREMENT 5
#define PULSE_DELAY 15

unsigned int speed=MIN_SPEED;
float delay;

DebounceIn  btn1(A0);
DebounceIn  btn2(A1);
DigitalIn  sns1(A2,PullUp);
DigitalIn  sns2(A3,PullUp);

DigitalOut dir(D5);
DigitalOut pul(D4);

void moving(int DIR, int MODE){
    if (MODE == 0){
        //accel
        dir=DIR;
        pul=1;
        wait_us(PULSE_DELAY);
        pul=0;
        speed += SPD_INCREMENT;
        delay = 1000000/speed;
        wait_us(delay);
        }
        
    if (MODE == 1){
        //moving
        dir=DIR;
        pul=1;
        wait_us(PULSE_DELAY);
        pul=0;
        delay = 1000000/speed;
        wait_us(delay);
        }
        
    if (MODE == 2){
        //decel
        //dir=DIR;
        while(speed>MIN_SPEED){
            pul=1;
            wait_us(PULSE_DELAY);
            pul=0;
            speed -= SPD_INCREMENT;
            delay = 1000000/speed;
            wait_us(delay);
            }
        }

}

int main()
{
    btn1.mode(PullUp);
    btn1.set_debounce_us(30000);
    btn1.set_samples(40);
    btn2.mode(PullUp);
    btn2.set_debounce_us(30000);
    btn2.set_samples(40);
    
    while(1){
        
        if((!btn1)&&(btn2)&&(sns1)&&(speed<MAX_SPEED)){
            //razgon vverh
            //printf("accel up speed: %d \n", speed);
            moving(1,0);
            }
        
        if((!btn1)&&(btn2)&&(sns1)&&(speed>=MAX_SPEED)){
            //movingUp
            //printf("moving up speed: %d \n", speed);
            moving(1,1);
            }
            
        if(((btn1)&&(btn2)||(!sns1))&&(speed>MIN_SPEED)){
            //breakUp
            //printf("braek up speed: %d \n", speed);
            moving(1,2);
            }
        
        if((btn1)&&(!btn2)&&(sns2)&&(speed<MAX_SPEED)){
            //razgon vniz
            //printf("accel up speed: %d \n", speed);
            moving(0,0);
            }
        
        if((btn1)&&(!btn2)&&(sns2)&&(speed>=MAX_SPEED)){
            //movingDown
            //printf("moving up speed: %d \n", speed);
            moving(0,1);
            }
            
        if(((btn1)&&(btn2)||(!sns2))&&(speed>MIN_SPEED)){
            //breakDown
            //printf("braek up speed: %d \n", speed);
            moving(0,2);
            }
    

    }
}
