/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "WIZnetInterface.h"
#include "platform/mbed_thread.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS        500

// variables
uint8_t mac_addr[6]={0x50,0x51,0x50,0x00,0x00,0x01};
char ip_addr[]="192.168.1.200";
char mask[]="255.255.255.0";
char gateway[]="192.168.1.101";
char udpMessage[1500];


WIZnetInterface wiz(PB_5,PB_4,PB_3,PA_10,PB_10);
WIZnet_UDPSocket udp;
//Endpoint consoleUDP;

static Timer g_timer;

Serial pc(USBTX, USBRX);





void disable_LSE() // PC_14, PC_15 I/O
{
    RCC_OscInitTypeDef OscInitStruct;
    HAL_RCC_GetOscConfig(&OscInitStruct);
//    pc.printf("%u %u %u %u\r\n",OscInitStruct.HSEState,OscInitStruct.LSEState,OscInitStruct.HSIState,OscInitStruct.LSIState);
    
    // Enable access to Backup domain
    HAL_PWR_EnableBkUpAccess();
    // Reset Backup domain
    __HAL_RCC_BACKUPRESET_FORCE();
    __HAL_RCC_BACKUPRESET_RELEASE();
    // Disable access to Backup domain
    HAL_PWR_DisableBkUpAccess();
    
    OscInitStruct.LSEState=RCC_LSE_OFF;
    HAL_RCC_OscConfig(&OscInitStruct);
    
    HAL_RCC_GetOscConfig(&OscInitStruct);
//    pc.printf("%u %u %u %u\r\n",OscInitStruct.HSEState,OscInitStruct.LSEState,OscInitStruct.HSIState,OscInitStruct.LSIState);
}

int main()
{

    g_timer.start();
    disable_LSE(); //free LSE pins
    wiz.init(mac_addr, ip_addr, mask, gateway);
    pc.printf("INIT...\r\n");
    wiz.connect();
    pc.printf("IP: %s\r\n", wiz.getIPAddress());
    
    
    printf("r:sock.open=%d\r\n",udp.init());
    printf("r:sock.bind=%d\r\n",udp.bind(8000));
    
    
    while (true) {

    thread_sleep_for(BLINKING_RATE_MS);
    }
}
