
#include <mbed.h>
#include "EthernetInterface.h"
#include "UDPSocket.h"
#include <string>
#include <math.h>
#include <millis.h>


int ID=8;

char myIP[16] = "192.168.1.10";
char serverIP[16] = "192.168.1.100";
char netMask[16] = "255.255.255.0";
char gateWay[16] = "192.168.1.1";


int portSend = 8000;
int portRecive = 9000;

int delay=200;//msecond


Serial pc(USBTX, USBRX);

EthernetInterface eth;

DigitalIn btn(A0);
DigitalIn btn1(A1);
int btn1Tick = 0;
int btn1State= 0;

Thread btn_thraed(osPriorityNormal, 16*1024);
Thread send_thread(osPriorityNormal, 16*1024);
Thread work_thread(osPriorityNormal, 16*1024);




typedef struct {
    char data[100];
		int size;
} mail_t;

Mail<mail_t, 16> recv_box;
Mail<mail_t, 16> send_box;    
    
    
Mutex datamutex;

int bt1=0;

void readBtn(void){
    while(1){
    	wait_us(100);
    	datamutex.lock();
	    if(!btn){
	        btn1Tick++;
	        if (btn1Tick>20){
	            btn1Tick=21;
	            btn1State=1;
	        }else{
	            datamutex.lock();
	            btn1State=0;
	            datamutex.unlock();
	        }
	    }else{ 
	        btn1Tick--;
	        if (btn1Tick<1){
	            btn1Tick=1;
	            btn1State=0;
	        }       
	    }
	    datamutex.unlock();
	}
}     

    
    
void recv(void)
{   
	SocketAddress sockAddr;
   // sockAddr.set_ip_address("192.168.2.1");
   // sockAddr.set_port(9000);
    UDPSocket sock;
    char  recv_data[100];
	pc.printf("r:sock.open=%d\r\n",sock.open(&eth));
	pc.printf("r:sock.bind=%d\r\n",sock.bind(portRecive));
   
    int ret;
    while(1)
    {
			pc.printf("r:listening...\r\n");
        ret = sock.recvfrom(&sockAddr, &recv_data, sizeof(recv_data));
			pc.printf("r:got\r\n");
        if (ret < 0) 
        {
					pc.printf("receive error:%d\r\n",ret);
					pc.printf("reset\r\n");
  				HAL_NVIC_SystemReset();

        } 
        else
        {
			pc.printf("r:%\r\n",recv_data);
            mail_t *mail = recv_box.alloc();
            int cpcnt;
            if (ret>sizeof(recv_data)) cpcnt=sizeof(recv_data); else cpcnt = ret; //copy no more than buffer size
            
			memset(mail->data,0,sizeof(mail->data));
			memcpy (mail->data, recv_data,cpcnt);
            recv_box.put(mail);
			pc.printf("r:put\r\n");
        }
    }    
}

void send(void)
{
    
    SocketAddress sockAddr;
    UDPSocket sock;
    pc.printf("sock.open=%d\r\n",sock.open(&eth));
    
    int ret;
    while(1)
    {
        //pc.printf("s::waiting...\r\n");
        
        osEvent evt = send_box.get(1);
        if (evt.status == osEventMail) 
        {
            mail_t *mail = (mail_t*)evt.value.p;
					//pc.printf("s:got data: %s; size: %d\n\r", mail->data,mail->size);
            
            ret = sock.sendto(serverIP,9000, mail->data, mail->size);
            if (ret < 0) 
            {
                pc.printf("send error:%d\r\n",ret);
								pc.printf("reset\r\n");
								HAL_NVIC_SystemReset();
            } 
            else
            {
                //pc.printf("sent %d bytes\r\n",ret);
                bt1=0;

            }
            send_box.free(mail);
        }    
                
            
        }
        
        
}


void status_callback(nsapi_event_t status, intptr_t param)
{
    printf("Connection status changed!\r\n");
    switch(param) {
        case NSAPI_STATUS_LOCAL_UP:
            printf("Local IP address set!\r\n");
            break;
        case NSAPI_STATUS_GLOBAL_UP:
            printf("Global IP address set!\r\n");
            break;
        case NSAPI_STATUS_DISCONNECTED:
            printf("No connection to network!\r\n");
            printf("System reset.\r\n");
            HAL_NVIC_SystemReset();
            break;
        case NSAPI_STATUS_CONNECTING:
            printf("Connecting to network!\r\n");
            break;
        default:
            printf("Net status: %d\r\n",param);
            break;
    }
}


unsigned int endian_swap(unsigned int x)
{
return
(x>>24) |
((x>>8) & 0x0000ff00) |
((x<<8) & 0x00ff0000) |
(x<<24);
}

void work(void)
{
	while(1)
	{
		wait_ms(delay);
		pc.printf("ID:%d\t State:%d\t\n",ID,btn1State);
		char datastr[128];
		mail_t *mail = send_box.alloc();
	    const char send_data[]="/data\x00\x00\x00\x2cii\x00";
	    memcpy(datastr,send_data,16);
	    int tmp;
	    tmp = endian_swap(ID);
	    memcpy(datastr+12,&tmp,4);
	    tmp = endian_swap(btn1State);
	    memcpy(datastr+16,&tmp,4);
	    memcpy (mail->data, datastr,20);
		mail->size = 20;
		send_box.put(mail);
	}
	
	
}
int main()
{   startMillis();
	sprintf(myIP,"%s%d",myIP, ID);


	pc.baud(115200);
    pc.printf("Hello. Alice!\r\n");
	
    pc.printf("eth.set=%d\r\n",eth.set_network(myIP,netMask,gateWay));
    int rz=eth.connect();
    eth.attach(&status_callback);
    pc.printf("Status interrupt attached.\r\n");
    pc.printf("eth.connect=%d\r\n",rz);
    
    btn1.mode(PullUp);
    
    
	if (rz<0) {
		pc.printf("reset\r\n");
		HAL_NVIC_SystemReset();
	}
    
    pc.printf("IP address is '%s'\r\n", eth.get_ip_address());
    
    send_thread.start(send);
    work_thread.start(work); 
    btn_thraed.start(readBtn);
    
    pc.printf("threads started\r\n");
    
	while (1)
    {
        osEvent evt = recv_box.get(10);
        if (evt.status == osEventMail) 
        {
            mail_t *mail = (mail_t*)evt.value.p;
            for (uint8_t i =0; i<100; i++)
            {
                if (mail->data[i] == 0 || mail->data[i] == 0x2c || mail->data[i] == 0x2f) mail->data[i]=0x20;
            }
            //pc.printf("main thread: %s\r\n", mail->data);
			mail->data[99]=0;
            //parse(mail->data); 
            send_box.free(mail);
        }   
       
    }
 
}

