#include "mbed.h"

#include "main.h"

//#include "PixelArray.h"
//#include "WS2812.h"




//_____________Parametrs_______________
#define dogIdleCount 20000

#define verbose 1

#define LED_ON_BRIGHT 50
#define LED_BLINK_PERIOD 100
#define LedWaitK 0
#define LedOnK 50
#define blinkBright 50



//_____________Variebles_______________

uint8_t gameState;

int report;
int gameDog=0;
int plasedSum = 0;//количество правильно положенных элементов
int k;
bool GameComplete=0;
float tS,tM,tI;
int sleepMode;




int color_set(uint8_t red,uint8_t green, uint8_t blue)
{
    return ((red<<16) + (green<<8) + blue);
}


//_________________________CLASSES___________________

LedGroupInside::LedGroupInside(PinName pin, int placeInTable, int size): __pa(size), __leds(pin, size, T0H, T0L, T1H, T1L)
{
    __placeInTable = placeInTable;
    __size = size;
    //PixelArray __pa(size);
    //WS2812 __leds(pin, __size, T0H, T0L, T1H, T1L);
}

void LedGroupInside::light(int mode)
{
    int R,G,B;

    switch (mode) {
        case LedWait:


            if(tableState[3][__placeInTable]!=LedWaitK) {
                if(tableState[3][__placeInTable]<LedWaitK) {
                    tableState[3][__placeInTable]++;
                } else if (tableState[3][__placeInTable]>LedWaitK) {
                    tableState[3][__placeInTable]--;
                }
                __pa.SetAll(color_set(0,0,0));
                __leds.write(__pa.getBuf());
            }
            break;

        case LedOn:


            if((tableState[3][__placeInTable]!=LedOnK)||(sleepMode==1)) {
                if(tableState[3][__placeInTable]<LedOnK) {
                    tableState[3][__placeInTable]++;
                } else if (tableState[3][__placeInTable]>LedOnK) {
                    tableState[3][__placeInTable]--;
                }
                int Bright = tableState[3][__placeInTable];

                R=0;
                G=LED_ON_BRIGHT*Bright/100;
                B=0;

                if(sleepMode==0) {
                    __pa.SetAll(color_set(R,G,B));
                    __leds.write(__pa.getBuf());
                } else {
                    __pa.SetAll(color_set(0,0,0));
                    __leds.write(__pa.getBuf());
                }
            }
            break;

        case LedOff:
            __pa.SetAll(color_set(0,0,0));
            __leds.write(__pa.getBuf());
            break;

        case LedBlink:
            if((tableState[3][__placeInTable]!=LedOnK)||(sleepMode==1)) {
                if(tableState[3][__placeInTable]<LedOnK) {
                    tableState[3][__placeInTable]++;
                } else if (tableState[3][__placeInTable]>LedOnK) {
                    tableState[3][__placeInTable]--;
                }
                int Bright = tableState[3][__placeInTable];

                R=LED_ON_BRIGHT*Bright/100;
                G=0;
                B=0;
                if(sleepMode==0) {
                    __pa.SetAll(color_set(R,G,B));
                    __leds.write(__pa.getBuf());
                } else {
                    __pa.SetAll(color_set(0,0,0));
                    __leds.write(__pa.getBuf());
                }
            }
            break;

        case LedRun:
            if(gameState!=idle) {
                if(tableState[3][__placeInTable]<LED_BLINK_PERIOD) {
                    tableState[3][__placeInTable]++;
                } else {
                    tableState[3][__placeInTable]=0;
                }

                float blinkVal=0;

                blinkVal =0.5 + sin((6.28/LED_BLINK_PERIOD)*tableState[3][__placeInTable])/2;
                //pc.printf("blinkVal %f \n", blinkVal);
                if(sleepMode==0) {
                    __pa.SetAll(color_set(0,blinkBright*blinkVal,0));
                    __leds.write(__pa.getBuf());
                } else {
                    __pa.SetAll(color_set(0,0,0));
                    __leds.write(__pa.getBuf());
                }
            }
            break;
    }
}


LedGroupStenka::LedGroupStenka(int placeInTable,int type, int sp1, int size1, int sp2, int size2)
{
    __type=type;
    __sp1=sp1;
    __size1=size1;
    __sp2=sp2;
    __size2=size2;
    __placeInTable = placeInTable;
    //PixelArray __pa(size);
    //WS2812 __leds(pin, __size, T0H, T0L, T1H, T1L);
}



//______________________________________
void LedGroupStenka::light(int mode)
{

    int R,G,B;

    switch (mode) {
        case LedWait://_______________________________________________________________________________________________________________________________


            if(tableState[3][__placeInTable]!=LedWaitK) {

                if(tableState[3][__placeInTable]<LedWaitK) {
                    tableState[3][__placeInTable]+=1;
                } else if (tableState[3][__placeInTable]>LedWaitK) {
                    tableState[3][__placeInTable]-=1;
                }

                writeLed(__type,0,0,0);
            }
            break;

        case LedOn://_______________________________________________________________________________________________________________________________
            if((tableState[3][__placeInTable]!=LedOnK)||(sleepMode==1)) {
                if(tableState[3][__placeInTable]<LedOnK) {
                    tableState[3][__placeInTable]+=2;
                } else if (tableState[3][__placeInTable]>LedOnK) {
                    tableState[3][__placeInTable]-=2;
                }

                int Bright = tableState[3][__placeInTable];

                R=0;
                G=LED_ON_BRIGHT*Bright/100;
                B=0;
                if(sleepMode==0) {
                    writeLed(__type,R,G,B);
                } else {
                    writeLed(__type,0,0,0);
                }
            }
            break;

        case LedOff:
            writeLed(__type,0,0,0);
            break;

        case LedBlink://_____________________________________________________________________________________________________________
            if((tableState[3][__placeInTable]!=LedOnK)||(sleepMode==1)) {
                if(tableState[3][__placeInTable]<LedOnK) {
                    tableState[3][__placeInTable]+=2;
                } else if (tableState[3][__placeInTable]>LedOnK) {
                    tableState[3][__placeInTable]-=2;
                }

                int Bright = tableState[3][__placeInTable];

                R=LED_ON_BRIGHT*Bright/100;
                G=0;
                B=0;
                if(sleepMode==0) {
                    writeLed(__type,R,G,B);
                } else {
                    writeLed(__type,0,0,0);
                }
            }
            break;

        case LedRun://________________________________________________________________________________________________________________________________________

            if(gameState!=idle) {
                if(tableState[3][__placeInTable]<LED_BLINK_PERIOD) {
                    tableState[3][__placeInTable]++;
                } else {
                    tableState[3][__placeInTable]=0;
                }

                float blinkVal=0;
                blinkVal = 0.5 + sin((6.28/LED_BLINK_PERIOD)*tableState[3][__placeInTable])/2;

                if(sleepMode==0) {
                    writeLed(__type,0,blinkBright*blinkVal,0);
                } else {
                    writeLed(__type,0,0,0);
                }

                //setStaticValToLed(__type,__sp1, __size1, __sp2, __size2, blinkBright*blinkVal,0,0);
            }
            break;
    }
}



void LedGroupStenka::writeLed(int type, uint8_t r, uint8_t g, uint8_t b)
{

    //pc.printf("type: %d R %d G %d B %d \n",type,r,g,b);
    //pc.printf("__sp1: %d __size1 %d __sp2: %d __size2 %d \n",__sp1,__size1,__sp2, __size2);

    if(type==0) {                                                                             //нормальная мембрана
        for(int t=__sp2; t<(__sp2+__size2); t++) {
            pa_stenkaLed_2.Set(numOfLed_stenkaLed_2-t-1,color_set(r,g,b));
        }

        for(int t=__sp1; t<(__sp1+__size1); t++) {
            pa_stenkaLed_3.Set(t,color_set(r,g,b));
        }
        //stenkaLed_2.write(pa_stenkaLed_2.getBuf());
        //stenkaLed_3.write(pa_stenkaLed_3.getBuf());

    } else if(type==1) {                                                                         //нормальная стенка

        //if(gameState!=bio) {
            for(int t=__sp2; t<(__sp2+__size2); t++) {
                pa_stenkaLed_2.Set(numOfLed_stenkaLed_2-t-1,color_set(r,g,b));
            }
            //stenkaLed_2.write(pa_stenkaLed_2.getBuf());
        //}

        for(int t=__sp1; t<(__sp1+__size1); t++) {
            pa_stenkaLed_1.Set(numOfLed_stenkaLed_1-t-1,color_set(r,g,b));
        }
        //stenkaLed_1.write(pa_stenkaLed_1.getBuf());

    } else if(type==2) {                                                                         //нулевой угол мембраны
        for(int t=__sp2; t<(__sp2+__size2); t++) {
            if(t>8) {
                pa_stenkaLed_2.Set(t-9,color_set(r,g,b));
            } else {
                pa_stenkaLed_2.Set(numOfLed_stenkaLed_2-t-1,color_set(r,g,b));
            }
        }
        //stenkaLed_2.write(pa_stenkaLed_2.getBuf());

        for(int t=__sp1; t<(__sp1+__size1); t++) {
            if(t>8) {
                pa_stenkaLed_3.Set(t-8+124,color_set(r,g,b));
            } else {
                pa_stenkaLed_3.Set(t,color_set(r,g,b));
            }
        }
        //stenkaLed_3.write(pa_stenkaLed_3.getBuf());

    } else if(type==3) {
        if(gameState!=bio) {                                                                       //нулевой угол стенки
            for(int t=__sp2; t<(__sp2+__size2); t++) {
                if(t>8) {
                    pa_stenkaLed_2.Set(t-9,color_set(r,g,b));
                } else {
                    pa_stenkaLed_2.Set(numOfLed_stenkaLed_2-t-1,color_set(r,g,b));
                }
            }

            //stenkaLed_2.write(pa_stenkaLed_2.getBuf());
        }
        for(int t=__sp1; t<(__sp1+__size1); t++) {
            if(t>8) {
                pa_stenkaLed_1.Set(t-9-1,color_set(r,g,b));
            } else {
                pa_stenkaLed_1.Set(numOfLed_stenkaLed_1-t-1,color_set(r,g,b));
            }
        }
        //stenkaLed_1.write(pa_stenkaLed_1.getBuf());
    }

}








//________________________REPORT_______________________
void stateReport()
{
    int i;

    pc.printf("\n");
    pc.printf("tableState: \n");
    pc.printf("Game mode: %d\n", gameState);
    pc.printf("WatchDog ticker: %d\n",gameDog);
    pc.printf("GameCimplete: %d , PlasedSum: %d To complete: %d\n", GameComplete,plasedSum, gameRule[gameState][33]);

    pc.printf("Time in led light tS: %f tM: %f tI: %f \n", tS,tM,tI);

    pc.printf("  num of pos:\t");
    i=0;
    for(int b=0; b<30; b++) {
        pc.printf("%d,\t",tableState[i][b]);
    }
    pc.printf("\n");

    pc.printf("  sensor state:\t");
    i=1;
    for(int b=0; b<30; b++) {
        pc.printf("%d,\t",tableState[i][b]);
    }
    pc.printf("\n");

    pc.printf("     led effect:\t");
    i=2;
    for(int b=0; b<30; b++) {
        pc.printf("%d,\t",tableState[i][b]);
    }
    pc.printf("\n");

    pc.printf("effect progress:\t");
    i=3;
    for(int b=0; b<30; b++) {
        pc.printf("%d,\t",tableState[i][b]);
    }
    pc.printf("\n");

}




//______________________BUTTON_______________________
void workButton()
{
    if (gameState==idle) {
        gameDog=0;
        if(Button_4) {
            gameState=rasta;
            if(verbose) {
                pc.printf("Game mode chenged to: rasta\n");
            }

            setLedRule(gameState);
            buttonLight(0,0,1);
        }
        if(Button_2) {
            gameState=bio;
            if(verbose) {
                pc.printf("Game mode chenged to: bio\n");
            }
            setLedRule(gameState);
            buttonLight(1,0,0);
        }
        if(Button_3) {
            gameState=bacterium;
            if(verbose) {
                pc.printf("Game mode chenged to: bacterium\n");
            }
            setLedRule(gameState);
            buttonLight(0,1,0);
        }

    } else if (((gameState==rasta)||(gameState==bio)||(gameState==bacterium))&&(plasedSum==0)) {
        if((Button_1)) {
            gameState=idle;
            if(verbose) {
                pc.printf("Game mode chenged to: idle  gameDog: %d \n", gameDog);
            }
            setLedRule(gameState);
            buttonLight(1,1,1);
            //stateReport();
            gameDog=0;
        }
    }

    if(gameDog>dogIdleCount) {
        sleepMode=1;
    } else {
        if(sleepMode==1) {
            sleepMode=0;
            setLedRule(gameState);
        }
    }

    if(plasedSum==0) {
        int R=(gameRule[idle][30] );
        int G=(gameRule[idle][31]);
        int B=(gameRule[idle][32]);
        pa_ButtonLed_1.SetAll(color_set(R,G,B));
        ButtonLed_1.write(pa_ButtonLed_1.getBuf());
    } else {
        pa_ButtonLed_1.SetAll(color_set(0,0,0));
        ButtonLed_1.write(pa_ButtonLed_1.getBuf());
    }
}

void buttonLight(int b2, int b3, int b4)
{

    int R=(gameRule[bio][30])*b2;
    int G=(gameRule[bio][31])*b2;
    int B=(gameRule[bio][32])*b2;
    pa_ButtonLed_2.SetAll(color_set(R,G,B));
    ButtonLed_2.write(pa_ButtonLed_2.getBuf());

    R=(gameRule[bacterium][30])*b3;
    G=(gameRule[bacterium][31])*b3;
    B=(gameRule[bacterium][32])*b3;
    pa_ButtonLed_3.SetAll(color_set(R,G,B));
    ButtonLed_3.write(pa_ButtonLed_3.getBuf());

    R=(gameRule[rasta][30])*b4;
    G=(gameRule[rasta][31])*b4;
    B=(gameRule[rasta][32])*b4;
    pa_ButtonLed_4.SetAll(color_set(R,G,B));
    ButtonLed_4.write(pa_ButtonLed_4.getBuf());
}



void chekRules()
{
    plasedSum = 0;
    for(int r=0; r<30; r++) {
        if (tableState[1][r]==1) {             //элемент на месте
            if(gameRule[gameState][r]==1) {    //проверяем должен ли он там лежать по правилам
                plasedSum++;
                if(GameComplete) {            //элемент на месте должен там быть, и конец игры
                    if(tableState[2][r]!=LedRun) {
                        tableState[2][r]=LedRun;
                        tableState[3][r]=0;
                        gameDog=0;

                    }
                } else if(tableState[2][r]!=LedOn) { //элемент на месте должен там быть, но еще не все собрали
                    tableState[2][r]=LedOn;
                    tableState[3][r]=0;
                    gameDog=0;
                }
            } else {                          //элемент на месте но его там не должно быть
                plasedSum--;

                if((tableState[2][r]!=LedBlink)&&(tableState[2][r]!=LedRun)) {
                    tableState[2][r]=LedBlink;
                    tableState[3][r]=0;
                    gameDog=0;
                }
            }
        } else if((gameRule[gameState][r]==1) && (tableState[1][r]!=1)) {    //если элемента нет но должен
            tableState[2][r]=LedWait;
            //plasedSum--;
        } else {
            tableState[2][r]=LedWait;
            if(GameComplete) {            //элемент нет на месте и не должен там быть, и конец игры
                tableState[2][r]=LedOff;             //выкл
                tableState[3][r]=0;
            }
        }
    }

    if(gameState==idle) {
        for(int r=0; r<30; r++) {
            tableState[2][r]=LedOff;
            tableState[3][r]=0;
        }
    }


    if(gameRule[gameState][33]==plasedSum) {  //проверяем конец игры
        GameComplete=1;             // перводим все диоды в бегущий режим
        gameDog+=20;
    } else {
        GameComplete=0;
    }
}




//________________________MAIN__________________________
int main()
{

    pc.baud(115200);
    pc.printf("Hello \n");
    if (verbose) {
        pc.printf("Verbose mode \n");
    } else {
        pc.printf("nonVerbose mode \n");
    }

    Button_1.mode(PullDown);
    Button_2.mode(PullDown);
    Button_3.mode(PullDown);
    Button_4.mode(PullDown);

    if (verbose) {
        pc.printf("Button configured \n");
    }

    //startUp_Led();

    gameState=idle;
    buttonLight(1,1,1);
    setLedRule(gameState);


    Ticker t;
    t.attach(&stateReport,1);
    while (true) {


        workButton();
        chekRules();
        lightLeds();
        gameDog++;
        //wait(0.1);

    }
}






//_____________________LED___Functions__________________________


void setLedRule(int mode)
{
    for(int r=0; r<30; r++) {              // перводим все диоды в соответвующий режим режим
        //if (gameRule[mode][r]==1) {
        tableState[2][r]=LedWait;
        //tableState[3][r]=0;
        /*} else {
            tableState[2][r]=LedOff;
            tableState[3][r]=0;
        }
        */
    }
}



void lightLeds()
{

    //Timer t;
    //t.start();

    stenkaLed_y1.light(tableState[2][0]);
    stenkaLed_s2.light(tableState[2][1]);
    stenkaLed_s3.light(tableState[2][2]);
    stenkaLed_y4.light(tableState[2][3]);
    stenkaLed_s5.light(tableState[2][4]);
    stenkaLed_y6.light(tableState[2][5]);
    stenkaLed_s7.light(tableState[2][6]);
    stenkaLed_s8.light(tableState[2][7]);
    stenkaLed_y9.light(tableState[2][8]);
    stenkaLed_s10.light(tableState[2][9]);

    membLed_y1.light(tableState[2][10]);
    membLed_s2.light(tableState[2][11]);
    membLed_s3.light(tableState[2][12]);
    membLed_y4.light(tableState[2][13]);
    membLed_s5.light(tableState[2][14]);
    membLed_y6.light(tableState[2][15]);
    membLed_s7.light(tableState[2][16]);
    membLed_s8.light(tableState[2][17]);
    membLed_y9.light(tableState[2][18]);
    membLed_s10.light(tableState[2][19]);

    //if(gameState!=bio) {
    stenkaLed_1.write(pa_stenkaLed_1.getBuf());
    //}
    stenkaLed_2.write(pa_stenkaLed_2.getBuf());
    stenkaLed_3.write(pa_stenkaLed_3.getBuf());

    yadroLed.light(tableState[2][20]);
    mitohondriyaLed.light(tableState[2][21]);
    endoplazmaLed.light(tableState[2][22]);
    plastidaLed.light(tableState[2][23]);
    vacuolLed.light(tableState[2][24]);
    lizosomaLed.light(tableState[2][25]);
    goldgiLed.light(tableState[2][26]);
    centorLed.light(tableState[2][27]);
    ribosomaLed.light(tableState[2][28]);
    nucleoidLed.light(tableState[2][29]);

    //tI=t.read();
    //t.stop();


}



void fadeEffect()
{
    for(int t=0; t<100; t++) {
        yadroLed.light(LedOff);
        mitohondriyaLed.light(LedOff);
        endoplazmaLed.light(LedOff);
        plastidaLed.light(LedOff);
        vacuolLed.light(LedOff);
        lizosomaLed.light(LedOff);
        goldgiLed.light(LedOff);
        centorLed.light(LedOff);
        ribosomaLed.light(LedOff);
        nucleoidLed.light(LedOff);
    }
}
void writeStenksLeds()
{
    stenkaLed_1.write(pa_stenkaLed_1.getBuf());
    stenkaLed_2.write(pa_stenkaLed_2.getBuf());
    stenkaLed_3.write(pa_stenkaLed_3.getBuf());
}


void startUp_Led()
{
    int tt=50;
    gameState=bio;


    for(int q=0; q<tt; q++) {
        stenkaLed_y1.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_y1.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s2.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_s2.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s3.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_s3.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_y4.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_y4.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s5.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_s5.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_y6.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_y6.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s7.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_s7.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s8.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_s8.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_y9.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        membLed_y9.light(LedBlink);
        writeStenksLeds();
    }
    for(int q=0; q<tt; q++) {
        stenkaLed_s10.light(LedBlink);
        writeStenksLeds();

    }
    for(int q=0; q<tt; q++) {
        membLed_s10.light(LedBlink);
        writeStenksLeds();
    }

    for(int q=0; q<tt; q++) {
        yadroLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        mitohondriyaLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        endoplazmaLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        plastidaLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        vacuolLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        lizosomaLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        goldgiLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        centorLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        ribosomaLed.light(LedBlink);
    }
    for(int q=0; q<tt; q++) {
        nucleoidLed.light(LedBlink);
    }


}


