#include "mbed.h"
//#include "main.h"

#define PERIOD 1000

extern int report;
extern uint8_t tableState[4][30];

class Sensor: public DigitalIn
{
public:

    Sensor (PinName pin, int i) : DigitalIn(pin), placeInTable(i)          // create the InterruptIn on the pin specified to Counter
    {
        DigitalIn::mode(PullDown);
        _samples = 10;
        _ticker.attach_us(this, &Sensor::_callback, PERIOD);
        _counter = 0;
        //_interrupt.rise(callback(this, &Sensor::increment)); // attach increment function of this counter instance
    }


protected:

        Ticker _ticker;
    //InterruptIn _interrupt;
    int placeInTable;
        int    _shadow;
        int    _counter;
        int    _samples;
    
    void _callback(void)
    {
        if (DigitalIn::read()) {
            if (_counter < _samples) _counter++;
            if (_counter >=_samples) {
                _shadow = 1;
                if(_counter < (_samples+5))_counter++;
                if(tableState[1][placeInTable]==0){report=1;}
                tableState[1][placeInTable]=1;
                
            }
                
        } else {
            if (_counter > 0) _counter--;
            if (_counter == 0) {
                _shadow = 0;
                if(tableState[1][placeInTable]==1){report=1;}
                tableState[1][placeInTable]=0;

            }
        }
    }
    


};


//__________SENSOR DEFINE___________________


Sensor Stenka_y1(PB_2,0);
Sensor Stenka_c2(PB_14,1);
Sensor Stenka_c3(PA_3,2);
Sensor Stenka_y4(PB_4,3);
Sensor Stenka_c5(PA_6,4);
Sensor Stenka_y6(PC_8,5);
Sensor Stenka_c7(PA_15,6);
Sensor Stenka_c8(PC_7,7);
Sensor Stenka_y9(PB_6,8);
Sensor Stenka_c10(PB_1,9);

Sensor Membrana_y1(PC_0,10);
Sensor Membrana_c2(PB_8,11);
Sensor Membrana_c3(PB_9 ,12);
Sensor Membrana_y4(PC_2,13);
Sensor Membrana_c5(PB_10,14);
Sensor Membrana_y6(PC_3,15);
Sensor Membrana_c7(PB_11,16);
Sensor Membrana_c8(PB_12,17);
Sensor Membrana_y9(PC_6,18);
Sensor Membrana_c10(PB_15,19);

Sensor Lizosoma(PC_9,25);
Sensor Vacuol(PC_10,24);
Sensor Yadro(PC_11,20);
Sensor Nucleoid(PC_12,29);
Sensor Mitohondriya(PD_0,21);
Sensor Ribosoma(PD_1,28);
Sensor Goldgi(PD_2,26);
Sensor Plastida(PD_3,23);
Sensor Centor(PD_4,27);
Sensor Endoplazma(PD_5,22);
