#include "mbed.h"
#include "PixelArray.h"
#include "WS2812.h"
#include "config.h"
#include "DebounceIn.h"


#include "sensor.h"

//#include "leds.h"


Serial pc(USBTX, USBRX);


DebounceIn Button_1(PE_0);
DebounceIn Button_2(PE_2);
DebounceIn Button_3(PE_4);
DebounceIn Button_4(PE_6);


//__________LEDS DEFINE___________________

#define LedOff 0
#define LedWait 1
#define LedOn 3
#define LedBlink 4
#define LedRun 5

#define T0H 20
#define T0L 105
#define T1H 70
#define T1L 123

#define idle 4
#define rasta 1
#define bio 2
#define bacterium 3



//__________TABLE DEFINE___________________


uint8_t tableState[4][30]= {
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29},  //num of sensor
    {0,0,0,0,0,0,0,0,0,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},  //sensor state
    {0,0,0,0,0,0,0,0,0,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},  //lype of light
    {0,0,0,0,0,0,0,0,0,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}   //intence or progress
};


uint8_t gameRule[5][34]= {
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,  0,  0,  0, 0},  //num of sensor
    {1,1,1,1,1,1,1,1,1,1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0,  0,255,  0, 27},  //rasta
    {0,0,0,0,0,0,0,0,0,0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0,200,100,  0, 16},  //bio
    {1,1,1,1,1,1,1,1,1,1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1,  0,200,200, 22},   //bacterium
    {0,0,0,0,0,0,0,0,0,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,150,150,150}    //idle
};


#define frontSize 5
float front[frontSize] = {0.0,0.01,0.40,0.01,0.0};


int color_set(uint8_t red,uint8_t green, uint8_t blue);
void startUp_Led();
void fadeEffect();
void lightLeds();
void setLedRule(int mode);
void setStaticValToLed(int type,int __sp1, int __size1, int __sp2, int __size2, int r, int g, int b);
void buttonLight(int b2, int b3, int b4);
void writeStenksLeds();


//___________________Classes__________________________
class LedGroupInside
{
public:
    LedGroupInside(PinName pin, int placeInTable, int size);
    //~LedGroup();
    void light(int mode);
private:
    PinName __outPin;
    int __mode;
    int __placeInTable;
    int __size;
    PixelArray __pa;
    WS2812 __leds;
};

class LedGroupStenka
{
public:
    LedGroupStenka(int placeInTable, int type, int sp1, int size1, int sp2, int size2);
    //~LedGroup();
    void light(int mode);
private:
    void writeLed(int type, uint8_t r, uint8_t g, uint8_t b);
    PinName __outPin;
    int __type;
    int __sp1, __size1;
    int __sp2, __size2;
    int __mode;
    int __placeInTable;
    int __size;
};

//__________________Config_LEDS_____________________________________
#define numOfLed_stenkaLed_1 177
PixelArray pa_stenkaLed_1(numOfLed_stenkaLed_1);
WS2812 stenkaLed_1(PF_0, numOfLed_stenkaLed_1, T0H, T0L, T1H, T1L);

#define numOfLed_stenkaLed_2 156
PixelArray pa_stenkaLed_2(numOfLed_stenkaLed_2);
WS2812 stenkaLed_2(PF_1, numOfLed_stenkaLed_2, T0H, T0L, T1H, T1L);

# define numOfLed_stenkaLed_3 137
PixelArray pa_stenkaLed_3(numOfLed_stenkaLed_3);
WS2812 stenkaLed_3(PF_2, numOfLed_stenkaLed_3, T0H, T0L, T1H, T1L);

//LedGroupStenka(int placeInTable,int type, int sp1, int size1, int sp2, int size2)
LedGroupStenka membLed_y1(10,2, 0, 21, 0, 25);
LedGroupStenka membLed_s2(11,0, 9, 9, 9, 9);
LedGroupStenka membLed_s3(12,0, 18, 9, 18, 9);
LedGroupStenka membLed_y4(13,0, 27, 21, 27, 26);
LedGroupStenka membLed_s5(14,0, 48, 8, 53, 8);
LedGroupStenka membLed_y6(15,0, 56, 21, 61, 26);
LedGroupStenka membLed_s7(16,0, 77, 9, 87, 9);
LedGroupStenka membLed_s8(17,0, 86, 9, 96, 9);
LedGroupStenka membLed_y9(18,0, 95, 21, 105, 26);
LedGroupStenka membLed_s10(19,0, 116, 9, 131, 9);

LedGroupStenka stenkaLed_y1(0,3, 0, 31, 0, 25);
LedGroupStenka stenkaLed_s2(1,1, 9, 9, 9, 9);
LedGroupStenka stenkaLed_s3(2,1, 18, 9, 18, 9);
LedGroupStenka stenkaLed_y4(3,1, 27, 31, 27, 26);
LedGroupStenka stenkaLed_s5(4,1, 58, 8, 53, 8);
LedGroupStenka stenkaLed_y6(5,1, 66, 31, 61, 26);
LedGroupStenka stenkaLed_s7(6,1, 97, 9, 87, 9);
LedGroupStenka stenkaLed_s8(7,1, 106, 9, 96, 9);
LedGroupStenka stenkaLed_y9(8,1, 115, 32, 105, 26);
LedGroupStenka stenkaLed_s10(9,1, 147, 9, 131, 9);

LedGroupInside lizosomaLed(PF_3, 25, 50);
LedGroupInside nucleoidLed(PF_4, 29, 50);
LedGroupInside yadroLed(PF_5,20,50);
LedGroupInside ribosomaLed(PF_6, 28, 40);
LedGroupInside goldgiLed(PF_7, 26, 40);
LedGroupInside endoplazmaLed(PF_8, 22, 50);
LedGroupInside plastidaLed(PF_9, 23, 50);
LedGroupInside centorLed(PF_10, 27, 30);
LedGroupInside mitohondriyaLed(PF_11, 21, 50);
LedGroupInside vacuolLed(PF_12, 24, 45);

//_____________Config Button LEDS____________________
PixelArray pa_ButtonLed_1(1);
WS2812 ButtonLed_1(PE_1, 1, T0H, T0L, T1H, T1L);

PixelArray pa_ButtonLed_2(1);
WS2812 ButtonLed_2(PE_3, 1, T0H, T0L, T1H, T1L);


PixelArray pa_ButtonLed_3(1);
WS2812 ButtonLed_3(PE_5, 1, T0H, T0L, T1H, T1L);


PixelArray pa_ButtonLed_4(1);
WS2812 ButtonLed_4(PE_7, 1, T0H, T0L, T1H, T1L);



//__________BUTTONS DEFINE___________________






