#include "main.h"
#include "mbed.h"
#include "Adafruit_GFX/Adafruit_SSD1306.h"
#include "sakuramori_kaori.h"

DigitalOut myled(LED1);
I2C i2c(I2C_SDA, I2C_SCL);
Adafruit_SSD1306_I2c gOled2(i2c, 0x3C << 1);
Serial pc(USBTX, USBRX);

void print_bitmap(const char* bitmap) {
    for (int ih = 1; ih <= 32; ih++) {
        for (int iw = 1; iw <= 128; iw++) {
            char pixel = bitmap[128 * (ih - 1) + iw - 1];
            //invert color
            if (pixel != 1) gOled2.drawPixel(iw, ih, WHITE);
        }
    }
}

int main() {
    pc.printf("call main();\r\n");
    for (int address = 1; address < 127; address++) {
        int error = i2c.write(address << 1, { }, 0, false); //We shift it left because mbed takes in 8 bit addreses
        if (error == 0) {
            pc.printf("I2C device found at address 0x%X\r\n", address); //Returns 7-bit addres
        }
    }
    //for debug output
    gOled2.pc = &pc;
    //loop
    const char *bitmaplst[] = {tokugawa_matsuri,shiraishi_tsumugi,sakuramori_kaori,mochizuki_anna};
    while (true) {
        for(auto bitmap : bitmaplst){
            gOled2.clearDisplay();
            gOled2.display();
            pc.printf("print bitmap:%p\r\n",bitmap);
            print_bitmap(bitmap);
            gOled2.display();
            wait(2);
        }
    }
}
