/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "BubbleDemo.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

#define RESET_FLAG  \
  do { \
    if (abortTest) { \
      abortTest = false; \
      wait(0.04); \
    } \
  } while(false)


#if 1 /* Displays without adapter */
#define DM_PIN_SPI_MOSI   D11
#define DM_PIN_SPI_MISO   D12
#define DM_PIN_SPI_SCLK   D13

#define DM_PIN_CS_TOUCH   D4
#define DM_PIN_CS_TFT     D10
#define DM_PIN_CS_SDCARD  D8
#define DM_PIN_CS_FLASH   D6
#else /* Displays with adapter */
#define DM_PIN_SPI_MOSI   A0
#define DM_PIN_SPI_MISO   D9
#define DM_PIN_SPI_SCLK   A1

#define DM_PIN_CS_TOUCH   D8
#define DM_PIN_CS_TFT     A3
#define DM_PIN_CS_SDCARD  D10
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/

static InterruptIn buttonInterrupt(P2_10);
static DigitalOut led(LED1);

//DmTftHX8353C tft;  /* DM_TFT18_101 */
//DmTftS6D0164 tft;  /* DM_TFT22_102 */
//DmTftIli9325 tft;  /* DM_TFT28_103 and DM_TFT24_104 */
DmTftIli9341 tft;  /* DM_TFT28_105 */
//DmTftSsd2119 tft;   /* DM_TFT35_107 */

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
  DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif  

/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Main
 *****************************************************************************/

int main (void)
{
    tft.init();

    BubbleDemo bubbleDemo(&tft, tft.width(), tft.height());
    while (1) {    
        bubbleDemo.run(750, 20);
    }
}
