#ifndef SEEED_LED_BAR_H
#define SEEED_LED_BAR_H
#include "mbed.h"
#include "DataClockPair.h"

class SeeedLedBar {
  private:
    DigitalOut datPin_;
    DigitalOut clkPin_;
    void pin_delay(int delay_us = 2);
    static const int glbCmdMode_ = 0x00;
    void send_sixtn_bits(int sixtnBits);
    void set_leds(int (&ledPower )[10]);
  public:
    SeeedLedBar(DataClockPair pins);
    void ten_on();
    void ten_off();
    void ten_set(int (&ledPower )[10]);
};

SeeedLedBar::SeeedLedBar(DataClockPair pins) : datPin_(pins.dataPin), clkPin_(pins.clockPin) { }

void SeeedLedBar::pin_delay(int delay_us) {
    wait_us(delay_us);
}

void SeeedLedBar::send_sixtn_bits(int sixtnBits) {
    for (int i = 0; i < 16; i++) {
        pin_delay();
        datPin_ = sixtnBits & 0x8000;
        sixtnBits <<= 1;
        pin_delay();
        clkPin_ = !clkPin_;
    }
}

void SeeedLedBar::set_leds(int (&ledPower )[10]) {
    send_sixtn_bits(glbCmdMode_);
    for (auto& i : ledPower) send_sixtn_bits(i);
    // Two extra empty bits for padding the command to the correct length
    send_sixtn_bits(0x00);
    send_sixtn_bits(0x00);
    pin_delay();
    datPin_ = 0;
    pin_delay();
    for (int i = 0; i < 4; i++) {
        pin_delay();
        datPin_ = 1;
        pin_delay();
        datPin_ = 0;
    }
}

void SeeedLedBar::ten_on() {
    int all_on[10] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
    set_leds(all_on);
}

void SeeedLedBar::ten_off() {
    int all_off[10] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    set_leds(all_off);
}

void SeeedLedBar::ten_set(int (&ledPower )[10]) {
    set_leds(ledPower);
}

#endif
