/* #include <cmath> */
#include "mbed.h"
namespace IRTempSensor{
#define SUR_TEMP_PIN PA_3 // Analog input pin connect to temperature sensor SUR pin
#define OBJ_TEMP_PIN PC_0 // Analog input pin connect to temperature sensor OBJ pin

double measuresureTemp(PinName surPin) {
    AnalogIn surTPin(surPin);
    float volts, resistance, temperature;
    volts = 0;
    for (int i = 0; i < 100; i++) {
        volts += surTPin.read();
        wait_us(10);
    }
    volts *= 3.3/100;
    resistance = 2000000*volts/(2.5-volts);
    temperature = 1/(log(resistance/100000)/3964 +(1/298.15)) - 273.15;
    return temperature;
}

float measureObjectTemp(PinName surPin, PinName objPin) {
    AnalogIn objTPin(objPin);
    float objV = 0;
    for (int i = 0; i < 100; i++) {
        objV += objTPin.read();
        wait_us(10);
    }
    objV *= 3.3/100;
    /* float pileSignal= objV - 2.5*17.4/(17.4+64); */
    float pileSignal = objV - 0.52;
    pileSignal *= 0.01;
    float ts = measuresureTemp(surPin) + 273.15;
    /* float calib = 1+(298.15 - ts)*0.0011; */
    float calib = 1;
    float k = 3.45*pow(10,-13)*calib;
    float kRecip = 2976078405624.9985;
    float kRecipAmp = kRecip * 0.01;
    /* float objT = (pileSignal*kRecip + ts*ts*ts*ts); */
    float objT = (objV*kRecipAmp -0.51*kRecipAmp + ts*ts*ts*ts);
    return pow(objT,0.25) - 273.15;
    /* return pileSignal*1000; */
    /* return objV*100; */
}};
