#ifndef MBED_SEEED_Q_TOUCH_H
#define MBED_SEEED_Q_TOUCH_H
#include "mbed.h"
#include "DataClockPair.h"

#define QTOUCH_REG_RESET        0X39            // reset
class SeeedQTouch {

    static const int devAddr_ = 0x1b;
    int readOpCode_;
    int writeOpCode_;
    static const int stateReg_ = 0x03;
    static const int calibrateReg_ = 0x38;
    I2C i2c_;
    int read_register_(int address, Serial* pc);
    int read_state_(Serial* pc);
  public:
    SeeedQTouch(DataClockPair pins);
    int key_touch(Serial* pc);
};

SeeedQTouch::SeeedQTouch(DataClockPair pins) : i2c_(pins.dataPin, pins.clockPin) {
    /* readOpCode_ = devAddr_ | 0x01; */
    /* writeOpCode_ = devAddr_ & 0xFE; */
    /* writeOpCode_ = devAddr_ | 0x00; */
    readOpCode_ = devAddr_;
    writeOpCode_ = devAddr_;
}

int SeeedQTouch::read_register_(int address, Serial* pc) {
    int success;
    char dataWrite[2];
    char resetWrite[2];
    char dataRead[2];
dataWrite[0] = 0x00;
dataWrite[1] = 0x55;
resetWrite[0] = QTOUCH_REG_RESET;
resetWrite[1] = 0x55;
    /* int success = i2c_.write(devAddr_, dataWrite, 1, 0); */
    /* if( pc ) pc->printf("requesting register %i success is %i", dataWrite[0], success); */
/* dataWrite[0] = 0x55; */
    success = i2c_.write(writeOpCode_, resetWrite, 2);
    success = i2c_.write(writeOpCode_, dataWrite, 2);
    if( pc ) pc->printf("requesting register %i success is %i", dataWrite[0], success);
    /* dataWrite[0] = stateReg_; */
    /* wait_ms(1); */
    /* i2c_.start(); */
    /* wait_ms(1); */
    /* success = i2c_.write(devAddr_, dataWrite, 1, 1); */
    /* wait_ms(1); */
    success = i2c_.read(readOpCode_, dataRead, 2);
    if( pc ) pc->printf("return value is %i or %i success is %i", dataRead[0] , dataRead[1], success);
    /* i2c_.stop(); */
    wait_ms(1);
    /* int result; */
    /* i2c_.start(); */
    wait_ms(1);
    /* result = i2c_.read(1); */
    wait_ms(1);
    /* i2c_.stop(); */
    return dataRead[0];
}

int SeeedQTouch::read_state_(Serial* pc) {
    return read_register_(0x03, pc);
}

int SeeedQTouch::key_touch(Serial* pc = 0) {
    int keys = read_state_(pc);
    return(keys);
}
#endif
