#include <algorithm>
#include <cmath>
#include "mbed.h"
#include "rtos.h"
#include "SeeedLedBar.h"
#include "SeeedFourDigitDisp.h"
#include "SeeedQTouch.h"
#include "SeeedChainableLED.h"
#include "SeeedIRTempSensor.h"

namespace  {

Serial pc(SERIAL_TX, SERIAL_RX);
AnalogIn knob(PA_3);

void blink_led() {
    for(DigitalOut led(PF_12);; Thread::wait(1000) ) {
        led = !led;
    }
}
} // namespace

int main() {
    pc.printf("\n\nstarting algorithm\n\n");
    Thread heartbeat;
    heartbeat.start(callback(blink_led));
    DataClockPair chainablePins, rgbPins, qTouchPins, dispPins, ledBarPins, surrDispPins;
    surrDispPins.dataPin = PG_0;
    surrDispPins.clockPin = PG_1;
    ledBarPins.dataPin = PE_9;
    ledBarPins.clockPin = PF_13;
    dispPins.dataPin = PE_13;
    dispPins.clockPin = PF_15;
    qTouchPins.dataPin = PB_9;
    qTouchPins.clockPin = PB_8;
    rgbPins.dataPin = PG_14;
    rgbPins.clockPin = PG_9;
    chainablePins.clockPin = PF_14;
    chainablePins.dataPin = PE_11;
    SeeedLedBar ledBar(ledBarPins);
    SeeedFourDigitDisp disp(dispPins);
    SeeedFourDigitDisp surrDisp(surrDispPins);
    SeeedQTouch qTouch(qTouchPins);
    SeeedChainableLED led_chain(chainablePins);
    SeeedChainableLED rgb_led(rgbPins);

    disp.set_digit(0,0);
    int knob_led_bar[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    ledBar.ten_on();
    disp.clear_display();
    led_chain.turn_on();
    led_chain.set_color_rgb(100,50,0);
    rgb_led.set_color_rgb(50,200,10);
    for (;; Thread::wait(1000) ) {
        qTouch.key_touch(&pc);
        surrDisp.set_integer(floor(IRTempSensor::measureObjectTemp(PA_3, PC_0)));
        auto led_frac = knob.read();
        int led_percent = floor(led_frac * 100);
        int tens = floor(led_frac * 10);
        int ones = led_percent % 10;
        ones = floor(ones * 10 / 8);
        if (ones > 8) ones = 8;
        for (int i = 0; i < tens; ++i) knob_led_bar[i] = 0xff;
        knob_led_bar[tens] = ones * 0xf;
        for (int i = ++tens; i < 10; ++i) knob_led_bar[i] = 0x00;
        ledBar.ten_set(knob_led_bar);
        disp.set_integer(floor(IRTempSensor::measuresureTemp(PA_3)));
        /* disp.set_integer(led_percent); */
        int eightBitInput = led_frac * 255;
        led_chain.set_color_rgb(eightBitInput, eightBitInput, eightBitInput);
        rgb_led.set_color_rgb(50,eightBitInput,10);
    }
    return 1;
}
