/* mbed Seeed 128x64 OLED Test
 *
 */
#include "mbed.h"
#include "rtos.h"
/* #include "mbed_logo.h"
 */
#include "SSD1308.h"

DigitalOut led(PA_8);
//Pin Defines for I2C Bus
#define OLED_D_SDA                  PA_10
#define OLED_D_SCL                  PA_9
I2C i2c(OLED_D_SDA, OLED_D_SCL);

// Host PC Communication channels
Serial pc(USBTX, USBRX); // tx, rx

// Instantiate OLED
SSD1308 oled(&i2c, 0x78);

Thread heartbeat;
void blink() {
    for(DigitalOut led(LED2);; Thread::wait(500) ) {
        led = !led;
    }
}

int main() {
    led = 1;
    const int waitTime = 1000;
    for (heartbeat.start(callback(blink));; Thread::wait(waitTime)) {
        led = !led;
        pc.printf("OLED test start\r");

        oled.writeString(0, 0, "Hello World! a b");
        oled.writeString(10, 0, "abcdefghij");
//  oled.printf("Hello World !");
        Thread::wait(3000);
        led = !led;

        oled.fillDisplay(0xAA);
        Thread::wait(3000);
        led = !led;

        oled.setDisplayOff();
        Thread::wait(500);
        led = !led;

        oled.setDisplayOn();
        Thread::wait(500);
        led = !led;

        oled.clearDisplay();
        Thread::wait(500);
        led = !led;

        oled.writeBigChar(0,0,'9');
        oled.writeBigChar(12,0,'8');
        oled.writeBigChar(12,18,'7');
        Thread::wait(3000);
        led = !led;
        oled.setDisplayInverse();
        Thread::wait(500);
        led = !led;

        oled.setDisplayNormal();
        Thread::wait(500);
        led = !led;
        oled.clearDisplay();

        /* oled.writeBitmap((uint8_t*) mbed_logo); */

        pc.printf("OLED test done\r\n");
    }
}
