#include "mbed.h"
#include "analogout_api.h"
#include "mbed-os/targets/TARGET_STM/TARGET_STM32L4/device/stm32l4xx_ll_dac.h"

#if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut sinOut( PA_4 ); // channel 1
#endif

#define PI        (3.141592653589793238462f)
#define AMPLITUDE (0.3)    // x * 3.3V
#define PHASE     (PI * 1.0f) // 2*pi is one period
#define OFFSET    (0.5f)

// Configuration for sinewave output
/* #define BUFFER_SIZE (540U) */
#define BUFFER_SIZE (1024U)
unsigned int buffer[BUFFER_SIZE];

void calculate_sinewave( void );

int main()
        {
        calculate_sinewave();

        const int stepBuffN = 12;
        float stepBuff[stepBuffN] = {};
        AnalogOut stepOut( PA_5 );

        for( int i = 0; i < stepBuffN; i += 3 )
                {
                stepBuff[i] = 3.0f / 3.3f;
                stepBuff[i + 1] = 2.0f / 3.3f;
                stepBuff[i + 2] = 1.0f / 3.3f;
                };

        stepOut = stepBuff[0];

        core_util_critical_section_enter();

        HAL_SuspendTick();

        core_util_critical_section_exit();

        dac_t* obj = &sinOut._dac;

        DAC_HandleTypeDef dacHandle = obj->handle;

        uint32_t dacChannel = obj->channel;

        for( unsigned int i = 0; i < BUFFER_SIZE; i++ )
                {
                buffer[i] *= 0xFFF;
                }

        while( 1 )
                {
                // sinewave output

                for( int i = 0; i < BUFFER_SIZE; ++i )
                        {
                        HAL_DAC_SetValue( &dacHandle, dacChannel, DAC_ALIGN_12B_R, buffer[i] );
                        HAL_DAC_Start( &dacHandle, dacChannel );
                        }
                }
        }

// Create the sinewave buffer
void calculate_sinewave( void )
        {
        for( unsigned int i = 0; i < BUFFER_SIZE; i++ )
                {
                float rads = 2.0f * ( PI * i ) / ( ( float )BUFFER_SIZE ); // Convert degree in radian
                buffer[i] = ( unsigned int )( 0xFFF * AMPLITUDE * cos( rads + PHASE ) + 0xFFF * OFFSET );
                }
        }
