/*
    Copyright (c) 2010 Andy Kirkham

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

/* #ifdef PINDETECT_EXAMPLE_COMPILE */

#include "mbed.h"
#include "PinDetect.h"
#include "SeeedChainableLED.h"

PinDetect  pin ( PF_15 );
DigitalOut chainStatus(LED2);
DigitalOut pauseStatus(LED3);
BusOut redLeds( PE_13, PF_14, PE_11, PE_9, PF_13 );
BusOut notRedLeds ( PF_12, PA_3, PC_0, PC_3, PF_3 );
DataClockPair iicChainLedsPins(PB_8, PB_9);
SeeedChainableLED iicChainLeds(iicChainLedsPins);
bool chainOn;
bool pause = false;

Thread statusThread;
void blink() {
    for(DigitalOut led(LED1);; Thread::wait(1000) ) {
        led = !led;
    }
}

/*
 * Note, the PinDetect can be defined thus:-
 *     PinDetect pin( p21, PullDown );
 * This allows you to specify the DigitalIn pinmode
 * when you create the PinDetect object. This means
 * using pin.mode() later is then no longer required.
 */

// C function callbacks follow.

void keyPressed( void ) {
    if (!pause) {
        redLeds = ~redLeds;
        notRedLeds = ~notRedLeds;
        if(!chainOn) iicChainLeds.set_color_rgb(255, 50, 2);
        else iicChainLeds.set_color_rgb(0, 0, 0);
        chainOn = !chainOn;
        pause = true;
    }
}

/* void keyReleased( void ) { */
/*     led2 = 0; */
/*     led3 = 0; */
/*     led4 = 0; */
/* } */

void keyPressedHeld( void ) {
    pause = false;
}
/* void keyReleasedHeld( void ) { */
/*     pause = false; */
/* } */

// The main program.

int main() {

    statusThread.start(callback(blink));

    iicChainLeds.set_color_rgb(0, 0, 0);
    chainOn = false;
    redLeds = 0;
    notRedLeds = ~0;

    pin.mode( PullDown );
    pin.attach_asserted( &keyPressed );
    pin.attach_asserted_held( &keyPressedHeld );
    pin.setSamplesTillAssert( 10 );
    pin.setSamplesTillHeld( 10000 );
    pin.setSampleFrequency(1000); // Defaults to 20ms.

    // This callback will often be of little use as it's
    // called after every assertion/deassertion. However,
    // it's provided for completeness. You may find a use
    // for it. If not, just don't attach a callback and it
    // will not activate.
    /* pin.attach_deasserted_held( &keyReleasedHeld ); */

    // You can define how many continuous samples must be
    // asserted before the attach_asserted() function is called.
    // This would mean 10 * 20ms debounce time = 200ms.

    // You can define how many continuous samples must be
    // asserted before the attach_asserted_held() function is called.
    // This would mean 200 * 20ms debounce time = 2seconds.

    // By default, "asserted" assumes the pin going high from 0volts to 5volts
    // and deasserted assumes going from 5volts to 0volts. You can invert this
    // logic so that going to 0volts is asserted and going to 5volts is deasserted
    // using this setup function:-
    //     pin.setAssertValue( 0 );

    // Sampling does NOT begin until you set the frequency. So, until
    // you call this function NO callbacks will be made. With no arguments
    // passed the default is 20000 microseconds (20ms). Specifiy the sampling
    // period in microseconds if you want a different value to 20ms.
    // For example, for a sampling period of 10ms do:-
    //     pin.setSampleFrequency( 10000 );
    // Note, if you change the sampling frequency you will probably also
    // want to change the number of samples till assert and held as show
    // above.

    for(;; Thread::wait(200) ) {
        chainStatus = chainOn;
        pauseStatus = pause;
    }
}

/* #endif */
