/**
 * @file    MPR121.cpp
 * @brief   Device driver - MPR121 capactiive touch IC
 * @author  sam grove
 * @version 1.0
 * @see     http://cache.freescale.com/files/sensors/doc/data_sheet/MPR121.pdf
 *
 * Copyright (c) 2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "MPR121.h"
#include "mbed_debug.h"

#define DEBUG 1

MPR121::MPR121(I2C &i2c) {
    _i2c = &i2c;
    _i2c_addr = (0x1b << 1);
}


bool MPR121::isPressed(void) {
    bool result = buttonPressed() == 0 ? false : true;
    return result;
}

uint16_t MPR121::buttonPressed(void) {
    char reg[1] = { 0x03 };
    int result=0;
    char data = -1;
    result = _i2c->write(_i2c_addr, reg, 1, true);
    if(result == 0 ) debug("result is 0");
    result = _i2c->read(_i2c_addr, &data, 1);
    if(result == 0 ) debug("result is 0");
    if(data == 4) data = 3;
    if(data == 2) data = 2;
    if(data == 1) data = 1;
    return data;
}
