#include "DotStar.h"
#include "rtos.h"

enum Init {brightness = 4, i2cHz = 400000, baud = 9600};
enum Register{ WHO_AM_I = 0x75, PWR_MGMT_1 = 0x6b, GYRO_CONFIG = 0x1b, CONFIG = 0x1a, GYRO_OFFSET = 0x13, GYRO = 0x43 };

Serial  dev(USBTX,USBRX);
DigitalOut cts(PA_6, 0);
SPI spiOne(PB_5, PB_4, PB_3);
I2C accel(PA_10,PA_9);
const int nLedsA = 65;
const int accRead = 0x68 << 1;
const int accWrite = accRead | 0x01;

struct XYZAccel {
    int16_t x,y,z;
};

XYZAccel getXYZ() {
    XYZAccel result;
    char reg[1] = {Register::GYRO};
    char data[6];
    int ret = accel.write(accWrite,reg,1, true);
    ret = accel.read(accRead,data,6);
    result.x  = (((int16_t)data[0]) << 8) | data[1];
    result.y  = (((int16_t)data[2]) << 8) | data[3];
    result.z  = (((int16_t)data[4]) << 8) | data[5];
    return result;
};

int main() {
    DotStar dotStarA(&spiOne, nLedsA);
    Thread::wait(1000);
    accel.frequency(Init::i2cHz);
    dev.baud(Init::baud);
    /* for (int i = 1; i < DotStar::brightest; i += 4) { */
    /*     dotStarA.set_brightness(i); */
    /* } */
    dotStarA.set_brightness(DotStar::half);
    int ret = 0;
    char reg[1];
    char data[7] = {};
    reg[0] = Register::WHO_AM_I;
    if(accel.write(accWrite,reg,1, true) != 0){
        dev.printf("writing RA failed\n");
    };
    ret = accel.read(accRead,data,1);
    if (ret != 0) dev.printf("reading RA failed\n");
    dev.printf("%i\n",data[0]);

    reg[0] = PWR_MGMT_1;
    ret = accel.write(accWrite,reg,1, true);
    if (ret != 0) dev.printf("writing RA failed\n");
    ret = accel.read(accRead,data,1);
    if (ret != 0) dev.printf("reading RA failed\n");
    dev.printf("%i\n",data[0]);
    data[0] &= ~(1<< 6);
    dev.printf("%i\n",data[0]);
    data[0] |= 1;
    dev.printf("%i\n",data[0]);
    data[1] = data[0];
    data[0]= reg[0];
    ret = accel.write(accWrite,data,2);
    if (ret != 0) dev.printf("writing data failed\n");

    ret = accel.write(accWrite,reg,1, true);
    if (ret != 0) dev.printf("writing RA failed\n");
    ret = accel.read(accRead,data,1);
    if (ret != 0) dev.printf("reading RA failed\n");
    dev.printf("%i\n",data[0]);

    reg[0] = Register::GYRO_CONFIG;
    ret = accel.write(accWrite,reg,1, true);
    if (ret != 0) dev.printf("writing RA failed\n");
    ret = accel.read(accRead,data,1);
    if (ret != 0) dev.printf("reading RA failed\n");
    dev.printf("%i\n",data[0]);
    data[0] |= 1<< 4;
    data[0] |= 1<< 3;
    data[0] &= ~1;
    data[0] &= ~(1<<1);
    dev.printf("%i\n",data[0]);
    data[1] = data[0];
    data[0]= reg[0];
    ret = accel.write(accWrite,data,2);
    if (ret != 0) dev.printf("writing data failed\n");

    reg[0] = Register::CONFIG;
    ret = accel.write(accWrite,reg,1, true);
    if (ret != 0) dev.printf("writing RA failed\n");
    ret = accel.read(accRead,data,1);
    if (ret != 0) dev.printf("reading RA failed\n");
    dev.printf("%i\n",data[0]);
    data[0] &= ~(1<< 2);
    data[0] &= ~1;
    data[0] &= ~(1<< 1);
    dev.printf("%i\n",data[0]);
    data[1] = data[0];
    data[0]= reg[0];
    ret = accel.write(accWrite,data,2);
    if (ret != 0) dev.printf("writing data failed\n");

    reg[0] = Register::GYRO_OFFSET;
    ret = accel.write(accWrite,reg,1, true);
    if (ret != 0) dev.printf("writing RA failed\n");
    ret = accel.read(accRead,data,6);
    if (ret != 0) dev.printf("reading RA failed\n");
    for (int i = 6; i < 1; --i) {
        data[i] = data[i-1];
    }
    data[0] = reg[0];
    data[1] = -1;
    data[3] = -1;
    data[5] = -1;
    data[2] = -1;
    data[4] = -8;
    data[6] = -18;
    ret = accel.write(accWrite,data,7);
    if (ret != 0) dev.printf("writing data failed\n");
    Thread::wait(500);

    /* for(int i = 0; i < 5; ++i){ */
    /* reg[0] = 0x43; */
    /* ret = accel.write(accWrite,reg,1, true); */
    /* if (ret != 0) dev.printf("writing RA failed\n"); */
    /* ret = accel.read(accRead,data,6); */
    /* if (ret != 0) dev.printf("reading RA failed\n"); */
    /* int16_t xAcc = (((int16_t)data[0]) << 8) | (int16_t)(data[1]); */
    /* int16_t yAcc = (((int16_t)data[2]) << 8) | (int16_t)(data[3]); */
    /* int16_t zAcc = (((int16_t)data[4]) << 8) | (int16_t)(data[5]); */
    /* dev.printf("x:%i  ",(xAcc)); */
    /* dev.printf("y:%i  ",(yAcc)); */
    /* dev.printf("z:%i\n",(zAcc)); */
    /* Thread::wait(500); */
    /* } */

    /* Thread::wait(100); */
    /* uint8_t dataInt = accel.read(0); */
    /* accel.stop(); */
    /* reg[0] = 0x75; */
    /* reg[0] = 6; */
    /* ret = accel.write(i2caddr,reg, 2); */
    /* ret = accel.read(i2caddr,data,1); */
    /* reg[0] = 0x1c; */
    /* reg[1] = 0; */
    /* ret = accel.write(i2caddr,reg,2); */
    /* dotStarA.set_brightness(ret*10); */
    /* reg[0] = 0x3b; */
    /* ret = accel.write(i2caddr,reg,1); */
    /* dotStarA.set_brightness(ret*10); */
    /* ret = accel.read(i2caddr,data,6); */
    /* dotStarA.set_brightness(ret*10); */
    /* struct Dirs{float x, y, z;}; */
    /* Dirs a; */
    /* a.x = short( (((short)data[1]) << 8) | data[0] ); */
    /* a.y = short( (((short)data[3]) << 8) | data[2] ); */
    /* a.z = short( (((short)data[5]) << 8) | data[4] ); */
    /* if(data[0] > -1 && data[0] < 4) dev.putc('y'); */
    /* dev.printf("%f",(a.x)); */
    /* dev.printf("%f",(a.y)); */
    /* dev.printf("%f",(a.z)); */
    dotStarA.set_brightness(DotStar::half);
    for (;;) {
        XYZAccel xyzData = getXYZ();
        RedGreenBlue rgb;
        rgb.red = abs(xyzData.x)>>6;
        rgb.green = abs(xyzData.y)>>6;
        rgb.blue = abs(xyzData.z)>>6;
        if(rgb.red < rgb.green && rgb.red < rgb.blue) rgb.red = 0;
        else if(rgb.blue < rgb.green && rgb.blue < rgb.red) rgb.blue = 0;
        else rgb.green = 0;
        dotStarA.set_rgb(rgb);
    }

}
