#include "mbed.h" 
#include "HDC1000.h"
#include "TSL2561_I2C.h"
//#include "AQM0802.h" //lcd
#include "LPS25H.h"

//InterruptIn button1(P1_12); //
//DigitalOut led1(LED1); //
//DigitalOut led2(LED2); //
//DigitalOut led3(LED3); //一定以上の回転数の時に光る
DigitalOut flash(LED4); //
HDC1000 hdc1000(P1_1, P1_0); //I2C_0 (sda, scl)
//DigitalOut myled(p5); //
TSL2561_I2C lum_sensor(P1_3, P1_2); //I2C_1 (sda, scl)
//DigitalOut myled(p5);
LPS25H lps25h(P1_7, P1_6); //I2C_3 (sda, scl)
Serial gps(P2_14, P2_15); //UART_0 (TxD, RxD)
Ticker flipper;
Serial pc(USBTX, USBRX); //USB_microB

/*
int i=0;
float f=0;
void rise1() {
    led1 = !led1;
}
void fall1() {
    led1 = !led1;
    i = i++;
}
void flip() {
    f=i;
    pc.printf("%2.1f \n",f/10);
    if(f>3)  {
        led3=1;
    }
    else{
        led3=0;
    }
    i=0;
    f=0;
}
*/

#define T0  288.15
#define dT  0.0065
#define P0  101325.0
#define g   9.80665
#define R   287.052
double GetAltitude(double p, double t){
    return (t+273.15)/dT*(pow((P0/p),dT*R/g)-1);
}

int main(){

/*
    button1.rise(&rise1); 
    button1.fall(&fall1);
    flipper.attach(&flip, 10); 
*/

    char msg[10];
    float h;
    float t;
    int a=0;
    int b=0;
    int c=0;
    int d=0;  
    int i=0;

    lum_sensor.enablePower();
    int rgb_readings[4];
    int e=0;   
    int m=0;
    int o=0;
    int k=0;
    int j=1;

    char msg2[10];
    int p, u, l;
    sprintf(msg2,"Barometer\r\n");
    pc.printf(msg2);
    sprintf(msg2,"Altimeter\r\n");
    pc.printf(msg2);
    //wait(1); //

    pc.printf("gps start! \r\n"); 

    while(1) {
        
        flash = !flash;
        //wait(0.25);
        
        for  (i=0;i<5;i++) {
            h = hdc1000.humidity();
            h = h/0x10000*100;
            sprintf(msg,"%4.1f%% \r\n",h);
            //lcd.locate(0,0);
            pc.printf(msg);
            t = hdc1000.temperature();
            t = t/0x10000*165-40;
            sprintf(msg,"%4.1fC \r\n",t);
            //lcd.locate(0,1);
            pc.printf(msg);
            a=h-d;
            d=b/c;  
            b+=h;
            c++;
/*
            if(a>=1.5){
                myled=1;
            }
            else{
                if(a<=-1.5){
                    myled=1;
                }
            else{
                myled=0;
            }
*/
        }    
        //wait(1);
        
//        for (j=1; j<5; j++){
            printf( "Luminosity: %4.2f\r\n", lum_sensor.getLux() );
//            wait_ms( 100 );
            e=lum_sensor.getLux() - k;
            k=m/o;
            m+=lum_sensor.getLux();
            o++;
/*
            if(e>=1.5){
                myled=1;
            }
            else{
                if(e<=-1.5){
                    myled=1;
                }
                else{
                myled=0;
               }
            }
*/
//        }
        
        p = (double)lps25h.pressure()/40.96;
        u = 42.5 + (double)lps25h.temperature()/480.0;
        l = GetAltitude(p,u);
        sprintf(msg2,"%6dPa\r\n",p);
        // lcd.locate(0,0);
        pc.printf(msg2);
        sprintf(msg2,"%4dm%2dC\r\n", l, u);
        // lcd.locate(0,1);
        pc.printf(msg2);
        // wait(1);
        
        pc.putc(gps.getc());     //パソコンに文字を送る
    }
}
