#include "mbed.h"

#include "console_output.h"
#include "test_us.h"
#include "test_compass.h"
#include "test_cny.h"
#include "test_motor.h"

#include "pin_connexions.h"


int main() {
    e_test user_choice ;
    ft_print_test_menu(pc);
    user_choice = ft_get_user_choice(pc);
    blue_button_interupt.fall(&change_direction);    
    
    
    
    
    /* Main loop */
    while(1)
    {
        
        wait_ms(250);
        
        /* Which component to test ? */
        switch (user_choice) 
        {
        case ULTRASONIC :
            do
            {
                ft_print_all_values_US(ultra_sonic, pc);
            } while (!pc.readable());
            user_choice = ft_get_user_choice(pc);
            pc.printf("\n");
            break;
            
        case COMPASS : 
            do
            {
                ft_print_compass_values(compass, pc);
            } while (!pc.readable());
            pc.printf("\n");
            user_choice = ft_get_user_choice(pc);
            break;
        
        case CNY70 : 
            do
            {
                pc.printf("\r CNY_1");
                ft_print_cny_analog_voltage(cny_1, pc);
                pc.printf("\t CNY_2");
                ft_print_cny_analog_voltage(cny_2, pc);
                pc.printf("\t CNY_3");
                ft_print_cny_analog_voltage(cny_3, pc);
            } while (!pc.readable());
            pc.printf("\n");
            user_choice = ft_get_user_choice(pc);
            break;
            
        case VBAT : 
            do
            {
                ft_print_to_be_imp(pc);
            } while (!pc.readable());
            pc.printf("\n");
            user_choice = ft_get_user_choice(pc);
            break;
        
        case LEFT_MOTOR : 
            ft_test_motor(Pwm_ML, DIR_1L, DIR_2L, pc);            
            user_choice = ft_get_user_choice(pc);
            break;
            
        case RIGHT_MOTOR: 
            ft_test_motor(Pwm_MR, DIR_1R, DIR_2R, pc);
            user_choice = ft_get_user_choice(pc);
            break;
            
    
        default : 
            ft_print_test_menu(pc);
            user_choice = ft_get_user_choice(pc);
            break;
        }
    }
 
}