

#include "mbed.h"
#include "BLEDevice.h"


#define SENSOR_READ_INTERVAL_S  (0.5F) 
#define ADV_INTERVAL_MS         (1000UL)
#define DEVICE_NAME             ("SOYNORDIC") // This can be read AFTER connecting to the device.
#define SHORT_NAME              ("HACKDEMO")    // Keep this short: max 8 chars if a 128bit UUID is also advertised.


DigitalOut led1(LED1);
DigitalOut led2(LED2);
BLEDevice   m_ble;







/**
 * This callback is scheduled to be called periodically via a low-priority interrupt.
 */
void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
    led2 = !led2;
}




int main(void)
{
    Ticker      ticker;


  
    ticker.attach(periodicCallback, SENSOR_READ_INTERVAL_S);

    m_ble.init();
  
    // Set the TX power in dBm units.
    // Possible values (in decreasing order): 4, 0, -4, -8, -12, -16, -20.
    m_ble.setTxPower(4);
   

    // Setup advertising (GAP stuff).
    m_ble.setDeviceName(DEVICE_NAME);
    m_ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    
    m_ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);

    m_ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                                (const uint8_t *)SHORT_NAME,
                                                (sizeof(SHORT_NAME) - 1));
   

 
    m_ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(ADV_INTERVAL_MS));
    m_ble.startAdvertising();

  
    while (true) {
        m_ble.waitForEvent();
    }
}
