#include "mbed.h"
#include "SDFileSystem.h"
#include "HeptaXbee.h"
#include "HeptaCamera_GPS.h"
#include "Hepta9axis.h"
#include "HeptaTemp.h"
#include "HeptaBattery.h"



Serial pc(USBTX,USBRX, 9600);
SDFileSystem sd(p5, p6, p7, p8, "sd");
HeptaBattery bat(p16, p25);
HeptaTemp temp(p17);
Hepta9axis n_axis(p28, p27, 0xD0, 0x18);
HeptaCamera_GPS cam_gps(p13, p14,p25, p24);
HeptaXbee xbee(p9,p10);

bool picture_here (float latitude, char ns, float longitude, char ew)
{
    return true;
    if ((latitude >=35.722) &(latitude<=35.728) && (longitude >=140.055) && (longitude<=140.060) && (ns == 'N')&&(ew=='E'))
        return true;
    return false;
}

bool send_here (float latitude, char ns, float longitude, char ew)
{
    return true;
    if ((latitude >=42.664) &(latitude<=42.699) && (longitude >=23.330) && (longitude<=23.350) && (ns == 'N')&&(ew=='E'))
        return true;
    return false;
}

int main() {
    xbee.baud(9600);
    //xbee.printf("Xbee comunication begin!\n\r");
    char * dir_name = "/sd/Pictures";
    mkdir(dir_name, 0777);

    HeptaCamera_GPS::ErrorNumber err1 = HeptaCamera_GPS::NoError;
    //
    mkdir("/sd/Data", 0777);
    pc.printf("Created!\n\r");  
    //cam_gps.gps_setting();
   // while (true) {
    //   xbee.putc(cam_gps.getc());
    //}

    while (true) {
        pc.printf("Begin messurment\n\r");
        float batLev;
        float tempMes;
        
        FILE *fp = fopen("/sd/Data/Data.txt", "w");
        if(fp == NULL) {
            error("Could not open file for write\n\r");
        }
        float time=0.0,latitude=0.0,longitude=0.0,hacu=0.0,altitude=0.0;
        char ns='A',ew='B';
        
        for (int i =0; i < 1; ++i)
        {  
            pc.printf("Mesurement attemt %d\r\n", i);
            fprintf(fp, "Picture data - Name\n\r--------------------------------\n\r");
            temp.temp_sense(&tempMes);
            fprintf(fp, "Temperature [%f]\n\r", tempMes);
            pc.printf( "Temperature [%f]\n\r", tempMes);
            bat.vol(&batLev);
            fprintf(fp, "Battery Level is [%f] Temperature [%f] ", batLev, tempMes);
            pc.printf("Battery Level is [%f] Temperature [%f] \n\r", batLev, tempMes);
            float mx,my,mz;
            n_axis.sen_mag(&mx,&my,&mz);
            fprintf(fp, "Magnetometer[%f,%f,%f] ",mx,my,mz);
            pc.printf("Magnet %f,%f,%f\r\n",mx,my,mz);
            float gx,gy,gz;
            n_axis.sen_gyro(&gx,&gy,&gz);
            fprintf(fp, "Gyroscope[%f,%f,%f] ",gx,gy,gz);
            pc.printf("Gyroscope %f,%f,%f\r\n",gx,gy,gz);
            float ax,ay,az;
            n_axis.sen_acc(&ax,&ay,&az);
            fprintf(fp, "Acceletarion[%f,%f,%f]\r\n",ax,ay,az);
            pc.printf("Acceletarion %f,%f,%f\r\n",ax,ay,az);
            int quality=0,stnum=0,gps_check=0;
            char aunit='m';
            pc.printf("GPS\r\n");
            wait(1.0);
            cam_gps.gps_setting();
            wait(1.0);
            cam_gps.gga_sensing(&time, &latitude, &ns, &longitude, &ew, &quality, &stnum, &hacu, &altitude, &aunit, &gps_check);
            if((gps_check==0)|(gps_check==1)) {
                fprintf(fp, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
                pc.printf("$GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c\r\n",time,latitude,ns,longitude,ew,quality,stnum,hacu,altitude,aunit);
            }
            fprintf(fp, "Picture data - End\n\r--------------------------------\n\r");
            pc.printf("Takeing picture \r\n");
            if (picture_here(latitude,ns,longitude,ew)){
                pc.printf("Takeing picture attemt %d\r\n", i);
                char fname[64];
                snprintf(fname, sizeof(fname), "%s/Picture%d.jpg", dir_name,  i);
                //snprintf(fname, sizeof(fname), "/sd/test.jpg");
                FILE *fp_jpeg = fopen(fname, "w");
                //cam_gps.set_image_file(fp_jpeg);
                //pc.printf("Setting baud\n\r");
                cam_gps.Sync();
                cam_gps.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution640x480);
                //pc.printf("Takeing picture\n\r");
                err1 = cam_gps.getJpegSnapshotPicture(fp_jpeg);
                //cam_gps.test_jpeg_snapshot_picture(1);
                if (HeptaCamera_GPS::NoError == err1) {
                    printf("[ OK ] : Picture taken\r\n");
                } else {
                    printf("[FAIL] : Picture failed (Error=%02X)\r\n", (int)err1);
                }
                fclose(fp_jpeg);
            }
            wait(1.0);
            //xbee.printf("num = %d\r\n",i);
        }
        fclose(fp); 
        pc.printf("Sending phase\r\n");
        if (send_here(latitude,ns,longitude,ew))
        {
            wait(5.0);
            FILE *fp1 = fopen("/sd/Data/Data.txt", "r");
            char buf[100];
            int nread = 0;
            if (fp1) {
                pc.printf("Sending data file %s\r\n", "/sd/Data/Data.txt");
                //xbee.printf("#SAT6");//%d%s",strlen("/sd/Data/Data.txt"),"/sd/Data/Data.txt");
                while ((nread = fread(buf, 1, sizeof buf, fp1)) > 0){
                    for (int i =0; i<nread; i++)
                    {
                        xbee.putc(buf[i]);
                    }
                }
               // xbee.printf("#SAT7");
            } else   error("Could not open file for write\n\r");
            fclose(fp1); 
            wait(15.0);
            for (int i =0; i < 1; ++i)
            {
                char fname[64];
                snprintf(fname, sizeof(fname), "%s/Picture%d.jpg", dir_name,  i);
                //snprintf(fname, sizeof(fname), "/sd/test.jpg");
                FILE *fp_jpeg = fopen(fname, "r");
                char buf[100];
                int nread = 0;
                if (fp_jpeg) {
                    pc.printf("Sending image file %s\r\n", fname);
                   // xbee.printf("#SAT8");//%d%s",strlen(fname),fname);
                    while ((nread = fread(buf, 1, sizeof buf, fp_jpeg)) > 0){
                        for (int i =0; i<nread; i++)
                        {
                            xbee.putc(buf[i]);
                        }
                    }
                  // xbee.printf("#SAT9");
                } else   error("Could not open file for write\n\r");
                fclose(fp_jpeg); 
            }
        }
    }
}