#ifndef QEI_H
#define QEI_H

#include "mbed.h"


class QEI
{
public:
    //引数は(A相のピン,B相のピン,1回転のパルスPPR,timerインスタンス,tickerインスタンス)
    QEI(PinName A,PinName B,int PPR,Timer *timer,Ticker *ticker);

    //初期設定
    void init();
    
    void Setting_ABstate_Table();//エンコーダの参照表に代入

    //MoveAve_pulse_to_RPSを使う場合に記述．3333usごとの割り込み
    void useAvePRS();

    //パルスカウント
    void PulseCount();

    //移動平均とるだけ
    void MoveAve_pulse();

    //移動平均を使ったRPS算出
    void MoveAve_pulse_to_RPS();

    //MoveAve_pulse_to_RPSで出したRPS値を返す
    double getRPS();

    //オドメトリ用関数
    double Odometry(double WheelDia);

    //返し値を反転させることができる
    void rotReverce();

    //パルスの確認
    int returnPulse();

    //********************処理をもっと頭良さげにしたものが2********************
    //*********************違いはコメントアウトで説明*************************
    void useAvePRS2();//をタイマー割り込みで使用

    void PulseCount2();//エンコーダの表を参照するようになった

    void rotReverce2();//表自体を反転させることで正転方向を変更する

    void MoveAve_pulse_to_RPS2();//表を参照した移動平均とrps．多分こっちのが処理少し軽い

    double getRPS2();//MoveAve_pulse_to_RPS2で出したRPS値を返す

    double Odometry2(double WheelDia);//オドメトリ用関数2


private:
    InterruptIn chA;
    InterruptIn chB;
    Timer *_timer;
    Ticker *_ticker;
    int _PPR;
    double current_rps;
    uint8_t pre_ABstate;
    const int data_sizeof = 30;
    int pulse,pulseData[data_sizeof];
    double pulseAve;
    double rps;
    int8_t NrotDIR;
    double pre_time;   //修正1：関数内staticからグローバルへ
    int ABstate_Table[15];
};

#endif